package com.bawnorton.trimica.client.mixin.model;

import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.compat.Compat;
import com.llamalad7.mixinextras.sugar.Local;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_10444;
import net.minecraft.class_10455;
import net.minecraft.class_1799;
import net.minecraft.class_310;

@MixinEnvironment("client")
@Mixin(class_10455.class)
abstract class SpecialModelWrapperMixin {
	@Inject(
			method = "update",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/client/renderer/special/SpecialModelRenderer;extractArgument(Lnet/minecraft/world/item/ItemStack;)Ljava/lang/Object;"
			)
	)
	private void applyPaletteToSpecialModelRenderState(CallbackInfo ci, @Local(argsOnly = true) class_1799 itemStack, @Local(argsOnly = true) class_10444 itemStackRenderState) {
		List<DynamicTrimTextureAtlasSprite> dynamicSprites = TrimicaClient.getRuntimeAtlases().getShieldSprites(class_310.method_1551().field_1687, itemStack);
		if (dynamicSprites.isEmpty()) return;

		boolean anyAnimated = false;
		for (DynamicTrimTextureAtlasSprite sprite : dynamicSprites) {
			TrimPalette palette = sprite.getPalette();
			if (palette != null && palette.isAnimated()) {
				anyAnimated = true;
			}
		}
		if (!anyAnimated) return;

		itemStackRenderState.method_70947();
		for (DynamicTrimTextureAtlasSprite sprite : dynamicSprites) {
			Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(sprite));
		}
	}
}
