package com.bawnorton.trimica.client.model;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.mixin.accessor.*;
import com.bawnorton.trimica.client.mixin.accessor.ModelBakery.ModelBakerImplAccessor;
import com.bawnorton.trimica.client.mixin.accessor.ModelDiscover.ModelWrapperAccessor;
import com.bawnorton.trimica.client.mixin.accessor.TextureSlots.ValueAccessor;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.trim.TrimmedType;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_10096;
import net.minecraft.class_10097;
import net.minecraft.class_10192;
import net.minecraft.class_10394;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_1058;
import net.minecraft.class_10813;
import net.minecraft.class_10819;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_1100;
import net.minecraft.class_11697;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4730;
import net.minecraft.class_5321;
import net.minecraft.class_5599;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import net.minecraft.class_8053;
import net.minecraft.class_9334;
import net.minecraft.class_9826;
import net.minecraft.client.resources.model.*;
import org.jetbrains.annotations.NotNull;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class TrimItemModelFactory {
	private final Map<class_2960, class_10439> modelCache = new HashMap<>();
	private final Map<class_2960, TrimPalette> paletteCache = new HashMap<>();
	private final Map<class_10439, class_2960> baseModelLocations = new HashMap<>();
	private class_1092.class_10816 resolvedModels;

	public TrimmedItemModelWrapper getOrCreateModel(class_10439 base, class_638 level, class_1799 stack, class_8053 trim) {
		TrimModelId trimModelId = getModelId(stack, trim);
		if (trimModelId == null) {
			return TrimmedItemModelWrapper.noTrim(base);
		}
		class_2960 overlayLocation = trimModelId.asSingle();
		if (MaterialAdditions.enableMaterialAdditions) {
			MaterialAdditions addition = stack.method_58695(MaterialAdditions.TYPE, MaterialAdditions.NONE);
			overlayLocation = addition.apply(overlayLocation);
		}
		class_2960 baseModelLocation = baseModelLocations.computeIfAbsent(base, k ->
				stack.method_58695(class_9334.field_54199, class_7923.field_41178.method_10221(stack.method_7909()))
						.method_45138("item/")
		);
		class_2960 newModelLocation = overlayLocation.method_45138(
				baseModelLocation.toString().replace(":", "_") + "/"
		);
		if (modelCache.containsKey(newModelLocation)) {
			return new TrimmedItemModelWrapper(modelCache.get(newModelLocation), paletteCache.get(newModelLocation), newModelLocation);
		}
		class_10439 model = createModel(baseModelLocation, newModelLocation, overlayLocation, base, level, stack, trim);
		modelCache.put(newModelLocation, model);
		return new TrimmedItemModelWrapper(model, paletteCache.get(newModelLocation), newModelLocation);
	}

	public static TrimModelId getModelId(class_1799 stack, class_8053 trim) {
		Optional<class_5321<class_10394>> assetId = Optional.ofNullable(stack.method_58694(class_9334.field_54196)).flatMap(class_10192::comp_3176);
		TrimmedType trimmedType = TrimmedType.of(stack);
		if (trimmedType == TrimmedType.UNKNOWN) return null;

		return TrimModelId.fromTrim(trimmedType, trim, assetId.orElse(null));
	}

	private class_10439 createModel(class_2960 baseModelLocation, class_2960 newModelLocation, class_2960 overlayLocation, class_10439 base, class_638 level, class_1799 stack, class_8053 trim) {
		class_10819 baseResolved = resolvedModels.comp_3775().get(baseModelLocation);
		if (baseResolved == null) {
			Trimica.LOGGER.error("Failed to find base resolved model: {}", baseModelLocation);
			return base;
		}
		class_10419.class_10420 slots = baseResolved.method_68031().comp_3743();
		Map<String, class_10419.class_10424> baseContents = slots.comp_3376();
		String targetLayer = findTargetLayer(baseContents);
		Map<String, class_10419.class_10424> contents = ImmutableMap.<String, class_10419.class_10424>builder()
				.putAll(slots.comp_3376())
				.put(targetLayer, ValueAccessor.trimica$init(new class_4730(overlayLocation, overlayLocation)))
				.buildKeepingLast();
		class_1100 generatedModel = new class_793(
				null,
				class_1100.class_4751.field_21858,
				false,
				null,
				new class_10419.class_10420(contents),
				class_2960.method_60656("item/generated")
		);
		class_10819 resolvedModel = ModelWrapperAccessor.trimica$init(newModelLocation, generatedModel, true);
		((ModelWrapperAccessor) resolvedModel).trimica$parent((class_10097.class_10814) baseResolved.method_68038());
		class_310 minecraft = class_310.method_1551();
		class_1092 modelManager = minecraft.method_1554();
		//? if >=1.21.10 {
		class_1088 modelBakery = new class_1088(
				class_5599.field_55267,
				minecraft.method_72703(),
				null,
				Map.of(),
				Map.of(),
				Map.of(newModelLocation, resolvedModel),
				ModelWrapperAccessor.trimica$init(class_10096.field_53660, class_10096.method_62629(), true)
		);
		class_11697 atlasManager = minecraft.method_72703();
		//?} else {
		/*ModelBakery modelBakery = new ModelBakery(
				EntityModelSet.EMPTY,
				Map.of(),
				Map.of(),
				Map.of(newModelLocation, resolvedModel),
				ModelDiscover$ModelWrapperAccessor.trimica$init(MissingBlockModel.LOCATION, MissingBlockModel.missingModel(), true)
		);
		*///?}
		DynamicTrimTextureAtlasSprite sprite = TrimicaClient.getRuntimeAtlases()
				.getItemAtlas(level, trim.comp_3179().comp_349())
				.getSprite(stack, trim.comp_3180().comp_349(), overlayLocation);
		paletteCache.put(newModelLocation, sprite.getPalette());
		class_9826 spriteGetter = new class_9826() {
			@Override
			public @NotNull class_1058 method_65739(class_4730 material, @NotNull class_10813 modelDebugName) {
				if (material.method_24147().equals(overlayLocation)) {
					return sprite;
				}
				//? if >=1.21.10 {
				return atlasManager.method_73030(material);
				//?} else {
				/*TextureAtlas atlas = modelManager.getAtlas(material.atlasLocation());
				return atlas.getSprite(material.texture());
				*///?}
			}

			@Override
			public @NotNull class_1058 method_65740(@NotNull String string, @NotNull class_10813 modelDebugName) {
				throw new IllegalStateException("Dynamic sprite missing: \"%s\" in model: \"%s\"".formatted(string, modelDebugName.debugName()));
			}
		};
		class_1088.class_10812 missingModels = ((ModelManagerAccessor) modelManager).trimica$missingModels();
		class_10439.class_10440 bakingContext = new class_10439.class_10440(
				ModelBakerImplAccessor.trimic$init(modelBakery, spriteGetter),
				class_5599.field_55267,
				//? if >=1.21.10 {
				atlasManager,
				null,
				//?}
				missingModels.comp_3772(),
				null
		);
		class_10430.class_10431 unbaked = new class_10430.class_10431(newModelLocation, ((BlockModelWrapperAccessor) base).trimica$tints());
		return unbaked.method_65587(bakingContext);
	}

	private String findTargetLayer(Map<String, class_10419.class_10424> baseContents) {
		int trimLayerIndex = -1;
		for (Map.Entry<String, class_10419.class_10424> entry : baseContents.entrySet()) {
			String key = entry.getKey();
			class_10419.class_10424 content = entry.getValue();
			if (key.startsWith("layer")) {
				String texture = switch(content) {
					case class_10419.class_10425 value -> value.comp_3378().method_24147().method_12832();
					case class_10419.class_10422 reference -> reference.comp_3377();
				};
				if (texture.startsWith("trims/")) {
					trimLayerIndex = Integer.parseInt(key.substring("layer".length()));
					break;
				}
			}
		}
		String targetLayer;
		if (trimLayerIndex != -1) {
			targetLayer = "layer" + trimLayerIndex;
		} else {
			String largestLayer = baseContents.keySet().stream()
					.filter(key -> key.startsWith("layer"))
					.max(Comparator.comparingInt(a -> Integer.parseInt(a.substring("layer".length()))))
					.orElse("layer0");
			int largestIndex = Integer.parseInt(largestLayer.substring("layer".length()));
			targetLayer = "layer" + (largestIndex + 1);
		}
		return targetLayer;
	}

	public void setResolvedModels(class_1092.class_10816 resolvedModels) {
		this.resolvedModels = resolvedModels;
	}

	public void registerBakedModel(class_10439 original, class_2960 model) {
		baseModelLocations.put(original, model);
	}

	public void clearModels() {
		modelCache.clear();
	}

	public void clear() {
		clearModels();
		((GuiRendererAccessor) ((GameRendererAccessor) class_310.method_1551().field_1773).trimica$guiRenderer()).trimica$invalidateItemAtlas();
		paletteCache.clear();
	}
}