package com.bawnorton.trimica.client.model;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.trim.TrimmedType;
import net.minecraft.class_10394;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_8053;
import org.jetbrains.annotations.Nullable;

public record TrimModelId(
		TrimmedType type,
		class_2960 patternId,
		class_2960 materialId,
		@Nullable class_2960 assetId
) {
	public class_2960 asSingle() {
		String assetPrefix = assetId == null ? "" : "%s/".formatted(assetId.toString().replace(":", "/"));
		assetPrefix += type.getName();
		return Trimica.rl("%s/%s/%s/%s".formatted(assetPrefix, patternId.method_12836(), patternId.method_12832(), materialId.method_12832()));
	}

	public static TrimModelId fromTrim(TrimmedType trimmedType, class_8053 trim, @Nullable class_5321<class_10394> assetKey) {
		class_2960 materialId = Trimica.rl(Trimica.getMaterialRegistry().getSuffix(trim.comp_3179().comp_349(), assetKey));
		class_2960 patternId = trim.comp_3180().comp_349().comp_1213();
		return new TrimModelId(trimmedType, patternId, materialId, assetKey == null ? null : assetKey.method_29177());
	}
}