package com.bawnorton.trimica.compat.elytratrims;

import com.bawnorton.trimica.api.BaseTextureInterceptor;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_8053;
import net.minecraft.class_8056;
import org.jetbrains.annotations.Nullable;

/**
 * This interceptor is used to provide custom base textures for the Elytra item when ElytraTrims is present.
 */
public class ElytraBaseTextureInterceptor implements BaseTextureInterceptor {
	@Override
	public class_2960 interceptItemTexture(@Nullable class_2960 expectedBaseTexture, class_1799 itemWithTrim, class_8053 armourTrim) {
		if (itemWithTrim.method_7909() != class_1802.field_8833) return expectedBaseTexture;

		return class_2960.method_60656("textures/trims/items/wings_trim.png");
	}

	@Override
	public class_2960 interceptArmourTexture(@Nullable class_2960 expectedBaseTexture, class_1799 itemWithTrim, class_8053 armourTrim) {
		if (itemWithTrim.method_7909() != class_1802.field_8833) return expectedBaseTexture;

		class_8056 pattern = armourTrim.comp_3180().comp_349();
		String assetId = pattern.comp_1213().method_12832();
		return class_2960.method_60656("textures/trims/entity/wings/%s.png".formatted(assetId));
	}
}
