package com.bawnorton.trimica.compat.elytratrims;

import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlas;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlases;
import com.bawnorton.trimica.compat.Compat;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.google.auto.service.AutoService;
import dev.kikugie.elytratrims.api.ETClientInitializer;
import dev.kikugie.elytratrims.api.render.ETRenderParameters;
import dev.kikugie.elytratrims.api.render.ETRenderingAPI;
import dev.kikugie.elytratrims.api.render.ETRenderingAPIUtils;
import dev.kikugie.elytratrims.render.impl.ETTrimsRenderer;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_10186;
import net.minecraft.class_10191;
import net.minecraft.class_11659;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_765;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;

//? if fabric {
@dev.kikugie.fletching_table.annotation.fabric.Entrypoint("elytratrims-client")
//?} else {
/*@AutoService(ETClientInitializer.class)
 *///?}
public class ElytraTrimsClientEntrypoint implements ETClientInitializer {
	@Override
	public void onInitializeClientET() {
		ETRenderingAPI.wrapRenderCall(ETTrimsRenderer.type, this::renderWithTrimica);
	}

	//? if >=1.21.10 {
	private boolean renderWithTrimica(ETRenderParameters parameters, class_11659 nodeCollector, BiFunction<ETRenderParameters, class_11659, Boolean> original) {
		Supplier<Boolean> callOriginal = () -> original.apply(parameters, nodeCollector);
		class_1799 stack = parameters.stack();
		List<class_8053> trims = AdditionalTrims.getAllTrims(stack);
		if (trims.isEmpty()) return callOriginal.get();

		class_638 level = class_310.method_1551().field_1687;
		if (level == null) return callOriginal.get();

		for (class_8053 trim : trims) {
			renderWithTrimicaInternal(level, stack, trim, parameters, callOriginal::get, (sprite, light) ->
					nodeCollector.method_73529(parameters.order().getAndIncrement())
							.method_73490(
									parameters.elytra(),
									parameters.object(),
									parameters.matrices(),
									parameters.render(),
									light,
									parameters.overlay(),
									parameters.color(),
									sprite,
									parameters.outline(),
									null
							));
		}
		return true;
	}

	//?} else {
	/*private boolean renderWithTrimica(ETRenderParameters parameters, Function<ETRenderParameters, Boolean> original) {
		Supplier<Boolean> callOriginal = () -> original.apply(parameters);
		ItemStack stack = parameters.stack();
		List<ArmorTrim> trims = AdditionalTrims.getAllTrims(stack);
		if (trims.isEmpty()) return callOriginal.get();

		ClientLevel level = Minecraft.getInstance().level;
		if (level == null) return callOriginal.get();

		for (ArmorTrim trim : trims) {
			renderWithTrimicaInternal(level, stack, trim, parameters, callOriginal::get, (sprite, light) -> {
				VertexConsumer vertexConsumer = sprite.wrap(ItemRenderer.getArmorFoilBuffer(parameters.source(), sprite.getRenderType(), stack.hasFoil()));
				Model elytra = parameters.elytra();
				elytra.renderToBuffer(parameters.matrices(), vertexConsumer, light, OverlayTexture.NO_OVERLAY, parameters.color());
			});
		}
		return true;
	}
	*///?}

	private void renderWithTrimicaInternal(
			class_638 level,
			class_1799 stack,
			class_8053 trim,
			ETRenderParameters parameters,
			Runnable original,
			Renderer renderer
	) {
		RuntimeTrimAtlases atlases = TrimicaClient.getRuntimeAtlases();
		class_8054 material = trim.comp_3179().comp_349();
		RuntimeTrimAtlas atlas = atlases.getEquipmentAtlas(level, material, class_10186.class_10190.field_54127);
		if (atlas == null) return;

		class_2960 overlayLocation = trim.method_67225(class_10186.class_10190.field_54127.method_67293(), class_10191.field_54142);
		MaterialAdditions additions;
		if (MaterialAdditions.enableMaterialAdditions) {
			additions = stack.method_58695(MaterialAdditions.TYPE, MaterialAdditions.NONE);
			overlayLocation = additions.apply(overlayLocation);
		}

		class_8056 pattern = trim.comp_3180().comp_349();
		DynamicTrimTextureAtlasSprite newSprite = atlas.getSprite(stack, pattern, overlayLocation);
		TrimPalette palette = newSprite.getPalette();
		if (palette == null) {
			original.run();
			return;
		}

		if (palette.isAnimated()) {
			Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(newSprite));
		}
		int light = palette.isEmissive() ? class_765.field_32767 : ETRenderingAPIUtils.getEffectiveLight(parameters);
	}

	interface Renderer {
		void render(DynamicTrimTextureAtlasSprite sprite, int light);
	}
}