package com.bawnorton.trimica.data.tags;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.mixin.accessor.HolderSet$NamedAccessor;
import com.bawnorton.trimica.mixin.accessor.HolderSet.NamedAccessor;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import com.mojang.serialization.Lifecycle;
import net.minecraft.class_10711;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.class_9248;
import net.minecraft.class_9334;
import net.minecraft.core.*;
import java.util.*;
import java.util.function.Function;

public final class TrimicaRuntimeTags {
	private final Set<UnboundTag> unboundTags = new HashSet<>();
	private final Map<String, class_6880.class_6883<class_8054>> references = new HashMap<>();

	public KeyHolder createMaterialKeyHolderForItem(class_6880.class_6883<class_1792> item) {
		class_2960 id = item.method_40237().method_29177();
		class_2960 generatedId = Trimica.rl("generated/%s/%s".formatted(id.method_12836(), id.method_12832()));
		class_5321<class_8054> resourceKey = class_5321.method_29179(class_7924.field_42083, generatedId);
		return new KeyHolder(resourceKey, class_6862.method_40092(class_7924.field_42083, generatedId));
	}

	public class_6880.class_6883<class_8054> createMaterialTagForItem(class_6880.class_6883<class_1792> itemRef, class_2385<class_8054> registry) {
		class_1792 item = itemRef.comp_349();
		class_1799 stack = item.method_7854();
		class_10711 materialProvider = stack.method_58694(class_9334.field_56397);
		if (materialProvider == null) {
			if (TrimMaterialRuntimeRegistry.enableTrimEverything) {
				Trimica.LOGGER.warn("Item \"{}\" does not provide a trim material, cannot create runtime tag for it", itemRef);
			}
			return null;
		}

		class_6880<class_8054> materialHolder = materialProvider.comp_3599()
				.comp_3636()
				.map(Function.identity(), key -> {
					class_6880.class_6883<class_8054> ref = registry.method_46746(key).orElse(null);
					if (ref == null) {
						Trimica.LOGGER.warn("Item \"{}\" tried to provide a trim material which does not exist, cannot create runtime tag for it", itemRef);
						return null;
					}
					return ref;
				});
		if (materialHolder == null) return null;

		class_8054 material = materialHolder.method_40229().map(registry::method_29107, Function.identity());
		if (material == null) {
			Trimica.LOGGER.warn("Item \"{}\"'s trim material doesn't exist, cannot create runtime tag for it", itemRef);
			return null;
		}

		KeyHolder keyHolder = createMaterialKeyHolderForItem(itemRef);
		class_9248 registrationInfo = new class_9248(Optional.empty(), Lifecycle.stable());
		class_5321<class_8054> resourceKey = keyHolder.resourceKey();
		class_6880.class_6883<class_8054> reference = registry.method_29113(material)
				.flatMap(registry::method_46746)
				.orElseGet(() -> registry.method_46746(resourceKey).orElseGet(() -> registry.method_10272(resourceKey, material, registrationInfo)));
		references.put(Trimica.getMaterialRegistry().getSuffix(material), reference);
		unboundTags.add(new UnboundTag(keyHolder.tagKey(), reference));
		Trimica.getMaterialRegistry().registerMaterialReference(reference);
		return reference;
	}

	public Set<class_6885.class_6888<class_8054>> bindTags(class_2378<class_8054> registry) {
		Set<class_6885.class_6888<class_8054>> runtimeMaterialTags = new HashSet<>();
		for (UnboundTag unboundTag : unboundTags) {
			class_6885.class_6888<class_8054> holderSet = NamedAccessor.trimica$init(registry, unboundTag.key());
			NamedAccessor accessor = (NamedAccessor) holderSet;
			accessor.trimica$bind(List.of(unboundTag.material()));
			runtimeMaterialTags.add(holderSet);
		}
		return runtimeMaterialTags;
	}

	public void clear() {
		clearUnbound();
		references.clear();
	}

	public void clearUnbound() {
		unboundTags.clear();
	}

	public class_6880<class_8054> convertHolder(class_6880<class_8054> holder) {
		if (!(holder instanceof class_6880.class_6881<class_8054>(class_8054 material))) return holder;

		String suffix = Trimica.getMaterialRegistry().getSuffix(material);
		return Objects.requireNonNullElse(references.get(suffix), holder);
	}

	private record UnboundTag(class_6862<class_8054> key, class_6880.class_6883<class_8054> material) {
	}

	public record KeyHolder(class_5321<class_8054> resourceKey, class_6862<class_8054> tagKey) {
	}
}