package com.bawnorton.trimica.data.tags;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.mixin.accessor.MappedRegistry$PendingTagsAnonymousAccessor;
import com.bawnorton.trimica.mixin.accessor.MappedRegistry.PendingTagsAnonymousAccessor;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;

public final class UnloadedTagHolder {
	private static final Map<class_2378.class_10106<?>, Map<class_6862<?>, class_6885<?>>> postponedContentsCache = new HashMap<>();
	private static final Map<class_6862<?>, class_6885<?>> postponedTagsContentCache = new HashMap<>();
	private static Map<class_5321<? extends class_2378<?>>, class_2378.class_10106<?>> unloadedTagsMap;

	public static void setUnloadedTags(List<class_2378.class_10106<?>> tags) {
		unloadedTagsMap = new HashMap<>();
		for (class_2378.class_10106<?> tag : tags) {
			unloadedTagsMap.put(tag.method_62693(), tag);
		}
	}

	@SuppressWarnings("unchecked")
	public static <T> class_6885<T> getUnloadedTag(class_6862<T> tagKey) {
		if (unloadedTagsMap == null) return class_6885.method_58563();

		class_6885<?> content = postponedTagsContentCache.get(tagKey);
		if (content != null) return (class_6885<T>) content;

		class_5321<? extends class_2378<T>> registry = tagKey.comp_326();
		class_2378.class_10106<T> pendingTags = (class_2378.class_10106<T>) unloadedTagsMap.get(registry);
		if (pendingTags == null) return class_6885.method_58563();

		content = getContent(tagKey, pendingTags);
		postponedTagsContentCache.put(tagKey, content);
		return (class_6885<T>) content;
	}

	@SuppressWarnings("unchecked")
	private static <T> class_6885<T> getContent(class_6862<T> tagKey, class_2378.class_10106<T> pendingTags) {
		Map<class_6862<?>, class_6885<?>> contents = postponedContentsCache.computeIfAbsent(
				pendingTags, key -> {
					if(pendingTags instanceof PendingTagsAnonymousAccessor accessor) {
						Map<class_6862<T>, List<class_6880<T>>> pendingContent = accessor.trimica$val$pendingContents();
						if (pendingContent == null) {
							Trimica.LOGGER.warn("Pending contents field is null in PendingTags for registry: {}", pendingTags.method_62693().method_29177());
							return Map.of();
						}
						return pendingContent.entrySet()
								.stream()
								.collect(ImmutableMap.toImmutableMap(
										tagKeyListEntry -> tagKeyListEntry != null ? tagKeyListEntry.getKey() : null,
										entry -> entry != null ? class_6885.method_40242(entry.getValue()) : class_6885.method_58563()
								));
					}
					Trimica.LOGGER.warn("Unknown PendingTags implementation: {} for registry: {}", pendingTags.getClass().getName(), pendingTags.method_62693().method_29177());
					return Map.of();
				}
		);
		class_6885<T> content = (class_6885<T>) contents.get(tagKey);
		if (content == null) {
			Trimica.LOGGER.warn("No content found for tag {} in registry {}", tagKey, pendingTags.method_62693().method_29177());
			content = class_6885.method_58563();
		}
		return content;
	}
}