package com.bawnorton.trimica.item;

import com.bawnorton.trimica.TrimicaToggles;
import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.item.trim.TrimicaTrimMaterials;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public final class TrimicaItems {
	private static final List<ItemHolder> ITEMS = new ArrayList<>();

	public static final class_1792 RAINBOWIFIER;
	public static final class_1792 ANIMATOR;
	public static final class_1792 FAKE_ADDITION;

	public static void forEach(BiConsumer<class_5321<class_1792>, class_1792> consumer) {
		for (ItemHolder itemHolder : ITEMS) {
			consumer.accept(itemHolder.key(), itemHolder.item());
		}
	}

	private static class_1792 create(String name, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 properties) {
		class_5321<class_1792> key = class_5321.method_29179(class_7924.field_41197, Trimica.rl(name));
		properties.method_63686(key);
		class_1792 item = factory.apply(properties);
		ITEMS.add(new ItemHolder(key, item));
		return item;
	}

	static {
		if (TrimicaToggles.enableItems) {
			if (TrimicaToggles.enableRainbowifier) {
				RAINBOWIFIER = create("rainbowifier", class_1792::new, new class_1792.class_1793()
						.method_7894(class_1814.field_8907)
						.method_67189(TrimicaTrimMaterials.RAINBOW)
				);
			} else {
				RAINBOWIFIER = null;
			}
			if (TrimicaToggles.enableAnimator) {
				ANIMATOR = create("animator", class_1792::new, new class_1792.class_1793()
						.method_7894(class_1814.field_8907)
				);
			} else {
				ANIMATOR = null;
			}
			FAKE_ADDITION = create("fake_addition", class_1792::new, new class_1792.class_1793());
		} else {
			RAINBOWIFIER = null;
			ANIMATOR = null;
			FAKE_ADDITION = null;
		}
	}

	private record ItemHolder(class_5321<class_1792> key, class_1792 item) {
	}
}
