package com.bawnorton.trimica.item.component;

import com.bawnorton.configurable.Configurable;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_8053;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;

public record AdditionalTrims(List<class_8053> trims) {
	public static class_9331<AdditionalTrims> TYPE;

	public static final Codec<AdditionalTrims> CODEC = class_8053.field_41994.listOf().xmap(
			list -> new AdditionalTrims(List.copyOf(list)),
			additionalTrims -> additionalTrims == null ? List.of() : List.copyOf(additionalTrims.trims)
	);

	public static final class_9139<class_9129, AdditionalTrims> STREAM_CODEC = class_9135.<class_9129, class_8053>method_56363().apply(class_8053.field_49278).method_56432(
			list -> new AdditionalTrims(List.copyOf(list)),
			additionalTrims -> additionalTrims == null ? List.of() : List.copyOf(additionalTrims.trims)
	);

	/**
	 * Whether you can add trims to already trimmed armor.
	 */
	@Configurable(onSet = "com.bawnorton.trimica.Trimica#refreshEverything")
	public static boolean enableAdditionalTrims = false;

	public AdditionalTrims(class_8053... trims) {
		this(List.of(trims));
	}

	public static AdditionalTrims empty() {
		return new AdditionalTrims();
	}

	public boolean isEmpty() {
		return trims.isEmpty();
	}

	public List<class_8053> mutableTrims() {
		return new ArrayList<>(trims);
	}

	public static List<class_8053> getAllTrims(class_9473 getter) {
		if (getter == null) return List.of();

		if (!enableAdditionalTrims) {
			class_8053 normalTrim = getter.method_58694(class_9334.field_49607);
			if (normalTrim != null) {
				return List.of(normalTrim);
			}
			return List.of();
		}

		AdditionalTrims additionalTrims = getter.method_58695(AdditionalTrims.TYPE, AdditionalTrims.empty());
		List<class_8053> allTrims = additionalTrims.mutableTrims();

		class_8053 normalTrim = getter.method_58694(class_9334.field_49607);
		if (normalTrim != null) {
			allTrims.addFirst(normalTrim);
		}
		return allTrims;
	}

	public static boolean tryAddTrim(class_1799 stack, class_8053 trim) {
		if (!stack.method_57826(class_9334.field_49607)) {
			stack.method_57379(class_9334.field_49607, trim);
			return true;
		}

		if (!enableAdditionalTrims) return false;

		AdditionalTrims additionalTrims = stack.method_58695(AdditionalTrims.TYPE, AdditionalTrims.empty());
		if (additionalTrims.trims().contains(trim)) return false;

		List<class_8053> newTrims = additionalTrims.mutableTrims();
		newTrims.add(trim);
		stack.method_57379(AdditionalTrims.TYPE, new AdditionalTrims(newTrims));
		return true;
	}

	public static int removeTrims(class_1799 stack, int count) {
		if (!enableAdditionalTrims) {
			if (count <= 0 || !stack.method_57826(class_9334.field_49607)) return count;

			stack.method_57381(class_9334.field_49607);
			if (MaterialAdditions.enableMaterialAdditions) {
				stack.method_57381(MaterialAdditions.TYPE);
			}
			return count - 1;
		}

		AdditionalTrims additionalTrims = stack.method_58695(AdditionalTrims.TYPE, AdditionalTrims.empty());
		if (count <= 0 || (additionalTrims.isEmpty() && !stack.method_57826(class_9334.field_49607))) return 0;

		List<class_8053> newTrims = additionalTrims.mutableTrims();
		for (; count > 0 && !newTrims.isEmpty(); count--) {
			newTrims.removeLast();
		}
		if (count > 0 && stack.method_57826(class_9334.field_49607)) {
			stack.method_57381(class_9334.field_49607);
			count--;
		}
		if (newTrims.isEmpty()) {
			stack.method_57381(AdditionalTrims.TYPE);
			if (!stack.method_57826(class_9334.field_49607) && MaterialAdditions.enableMaterialAdditions) {
				stack.method_57381(MaterialAdditions.TYPE);
			}
		} else {
			stack.method_57379(AdditionalTrims.TYPE, new AdditionalTrims(newTrims));
		}
		return count; // remainder
	}

	public static void correctTrimComponents(class_1799 stack) {
		if (!enableAdditionalTrims) return;

		if (!stack.method_57826(AdditionalTrims.TYPE) || stack.method_57826(class_9334.field_49607)) return;

		AdditionalTrims additionalTrims = stack.method_58695(AdditionalTrims.TYPE, AdditionalTrims.empty());
		if (additionalTrims.isEmpty()) return;

		List<class_8053> trims = additionalTrims.mutableTrims();
		class_8053 firstTrim = trims.removeFirst();
		stack.method_57379(class_9334.field_49607, firstTrim);
		if (trims.isEmpty()) {
			stack.method_57381(AdditionalTrims.TYPE);
		} else {
			stack.method_57379(AdditionalTrims.TYPE, new AdditionalTrims(trims));
		}
	}

	public static boolean hasTrim(class_1799 stack, class_8053 trim) {
		List<class_8053> allTrims = getAllTrims(stack);
		for (class_8053 armorTrim : allTrims) {
			if (armorTrim.equals(trim)) {
				return true;
			}
		}
		return false;
	}
}
