package com.bawnorton.trimica.item.component;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_10192;
import net.minecraft.class_10711;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_8051;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;

public final class ComponentUtil {
	public static @Nullable class_8051 getArmourType(class_9473 componentGetter) {
		class_10192 equippable = componentGetter.method_58694(class_9334.field_54196);
		if (equippable == null) return null;

		class_1304 slot = equippable.comp_3174();
		return switch (slot) {
			case field_6166 -> class_8051.field_41937;
			case field_6172 -> class_8051.field_41936;
			case field_6174 -> class_8051.field_41935;
			case field_6169 -> class_8051.field_41934;
			default -> null;
		};
	}

	public static @NotNull List<class_1799> getTrimmedEquipment(class_8053 trim) {
		return Stream.of(
				class_1802.field_8805,
				class_1802.field_8058,
				class_1802.field_8348,
				class_1802.field_8285,
				class_1802.field_8255
		).map(item -> {
			class_1799 stack = item.method_7854();
			stack.method_57379(class_9334.field_49607, trim);
			return stack;
		}).toList();
	}

	@SuppressWarnings("unchecked")
	public static <T> @Nullable T getFakeComponents(class_9473 instance, T original, class_9331<? extends T> type) {
		if (original != null) return original;

		if (type == class_9334.field_56397 && instance instanceof class_1799 stack) {
			if (TrimMaterialRuntimeRegistry.enableTrimEverything) {
				return (T) new class_10711(Trimica.getMaterialRegistry().getOrCreate(stack));
			}
		}
		return null;
	}

	public static <T> void setFakeComponents(DataComponentSetter setter, class_9473 getter, class_9331<T> type, @Nullable T object) {
		if (!MaterialAdditions.enableMaterialAdditions) return;
		if (object == null) return;

		if (type == class_9334.field_49607) {
			class_8053 trim = (class_8053) object;
			MaterialAdditions additions = getter.method_58695(MaterialAdditions.TYPE, MaterialAdditions.NONE);
			class_8054 trimMaterial = trim.comp_3179().comp_349();
			additions = additions.and(Trimica.getMaterialRegistry().getIntrinsicAdditions(trimMaterial));
			if (additions.isEmpty()) return;

			setter.set(MaterialAdditions.TYPE, additions);
		} else if (AdditionalTrims.enableAdditionalTrims && type == AdditionalTrims.TYPE) {
			AdditionalTrims additionalTrims = (AdditionalTrims) object;
			MaterialAdditions additions = getter.method_58695(MaterialAdditions.TYPE, MaterialAdditions.NONE);
			for (class_8053 trim : additionalTrims.trims()) {
				class_8054 trimMaterial = trim.comp_3179().comp_349();
				additions = additions.and(Trimica.getMaterialRegistry().getIntrinsicAdditions(trimMaterial));
			}
			if (additions.isEmpty()) return;

			setter.set(MaterialAdditions.TYPE, additions);
		}
	}
}
