package com.bawnorton.trimica.item.component;

import com.bawnorton.configurable.Configurable;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;

public record MaterialAdditions(List<class_2960> additionKeys) {
	public static final MaterialAdditions NONE = new MaterialAdditions(List.of());

	/**
	 * Whether material additions are enabled.
	 * Disabling this will prevent any material additions from being applied
	 * and will prevent any recipes that use material additions from working.
	 */
	@Configurable(onSet = "com.bawnorton.trimica.Trimica#refreshEverything")
	public static boolean enableMaterialAdditions = true;

	public static class_9331<MaterialAdditions> TYPE;

	public static final Codec<MaterialAdditions> CODEC = class_2960.field_25139.listOf().xmap(
			list -> new MaterialAdditions(List.copyOf(list)),
			materialAddition -> materialAddition == null ? List.of() : List.copyOf(materialAddition.additionKeys)
	);

	public static final class_9139<ByteBuf, MaterialAdditions> STREAM_CODEC = class_9135.<ByteBuf, class_2960>method_56363().apply(class_2960.field_48267).method_56432(
			list -> new MaterialAdditions(List.copyOf(list)),
			materialAddition -> materialAddition == null ? List.of() : List.copyOf(materialAddition.additionKeys)
	);

	public MaterialAdditions(class_2960 addition) {
		this(List.of(addition));
	}

	public MaterialAdditions and(class_2960 addition) {
		List<class_2960> additions = new ArrayList<>(this.additionKeys);
		if (additions.contains(addition)) return this;

		additions.add(addition);
		return new MaterialAdditions(additions);
	}

	public MaterialAdditions and(MaterialAdditions additions) {
		if (additions == null || additions.isEmpty()) return this;

		List<class_2960> newAdditions = new ArrayList<>(this.additionKeys);
		for (class_2960 addition : additions.additionKeys) {
			if (!newAdditions.contains(addition)) {
				newAdditions.add(addition);
			}
		}
		return new MaterialAdditions(newAdditions);
	}

	public boolean matches(class_2960 key) {
		for (class_2960 additionKey : additionKeys) {
			if (key.equals(additionKey)) {
				return true;
			}
		}
		return false;
	}

	public boolean isEmpty() {
		return additionKeys.isEmpty();
	}

	public class_2960 apply(class_2960 id) {
		if (additionKeys.isEmpty()) {
			return id;
		}
		String additionPrefix = "/additions/";
		String path = id.method_12832();
		int index = path.indexOf(additionPrefix);
		StringBuilder newPath;
		if (index != -1) {
			newPath = new StringBuilder(path.substring(0, index + additionPrefix.length()));
		} else {
			newPath = new StringBuilder(path + additionPrefix);
		}
		for (class_2960 additionKey : additionKeys) {
			newPath.append(additionKey.method_12836()).append("/").append(additionKey.method_12832()).append("/");
		}
		return id.method_45136(newPath.toString());
	}

	public static int removeMaterials(class_1799 stack, int count) {
		if (!enableMaterialAdditions) return count;

		MaterialAdditions additions = stack.method_58695(MaterialAdditions.TYPE, MaterialAdditions.NONE);
		if (additions.isEmpty()) return count;

		List<class_2960> newAdditions = new ArrayList<>(additions.additionKeys);
		for (; count > 0 && !newAdditions.isEmpty(); count--) {
			newAdditions.removeLast();
		}
		if (newAdditions.isEmpty()) {
			stack.method_57381(MaterialAdditions.TYPE);
		} else {
			stack.method_57379(MaterialAdditions.TYPE, new MaterialAdditions(newAdditions));
		}
		return count;
	}

}