package com.bawnorton.trimica.api.impl;

import com.bawnorton.trimica.api.*;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.util.SortableEndpointHolder;
import org.jetbrains.annotations.ApiStatus;

import java.util.PriorityQueue;
import java.util.Queue;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_9473;

@SuppressWarnings("unused")
@ApiStatus.Internal
public final class TrimicaApiImpl implements TrimicaApi {
	public static final TrimicaApiImpl INSTANCE = new TrimicaApiImpl();

	private final Queue<SortableEndpointHolder<BaseTextureInterceptor>> baseTextureInterceptors = new PriorityQueue<>();
	private final Queue<SortableEndpointHolder<CraftingRecipeInterceptor>> craftingRecipeInterceptors = new PriorityQueue<>();
	private final Queue<SortableEndpointHolder<PaletteInterceptor>> paletteInterceptors = new PriorityQueue<>();

	public void registerBaseTextureInterceptor(int priority, BaseTextureInterceptor baseTextureInterceptor) {
		baseTextureInterceptors.add(new SortableEndpointHolder<>(baseTextureInterceptor, priority));
	}

	public void registerCraftingRecipeInterceptor(int priority, CraftingRecipeInterceptor craftingRecipeInterceptor) {
		craftingRecipeInterceptors.add(new SortableEndpointHolder<>(craftingRecipeInterceptor, priority));
	}

	public void registerPaletteInterceptor(int priority, PaletteInterceptor paletteInterceptor) {
		paletteInterceptors.add(new SortableEndpointHolder<>(paletteInterceptor, priority));
	}

	public class_2960 applyBaseTextureInterceptorsForItem(class_2960 expectedBaseTexture, class_1799 itemWithTrim, class_8053 armourTrim) {
		for (SortableEndpointHolder<BaseTextureInterceptor> endpointHolder : baseTextureInterceptors) {
			expectedBaseTexture = endpointHolder.endpoint().interceptItemTexture(expectedBaseTexture, itemWithTrim, armourTrim);
		}
		return expectedBaseTexture;
	}

	public class_2960 applyBaseTextureInterceptorsForArmour(class_2960 expectedBaseTexture, class_1799 itemWithTrim, class_8053 armourTrim) {
		for (SortableEndpointHolder<BaseTextureInterceptor> endpointHolder : baseTextureInterceptors) {
			expectedBaseTexture = endpointHolder.endpoint().interceptArmourTexture(expectedBaseTexture, itemWithTrim, armourTrim);
		}
		return expectedBaseTexture;
	}

	public class_2960 applyBaseTextureInterceptorsForShield(class_2960 expectedBaseTexture, class_9473 componentGetter, class_8053 armourTrim) {
		for (SortableEndpointHolder<BaseTextureInterceptor> endpointHolder : baseTextureInterceptors) {
			expectedBaseTexture = endpointHolder.endpoint().interceptShieldTexture(expectedBaseTexture, componentGetter, armourTrim);
		}
		return expectedBaseTexture;
	}

	public class_1856 applyCraftingRecipeInterceptorsForAddition(class_1856 current) {
		for (SortableEndpointHolder<CraftingRecipeInterceptor> endpointHolder : craftingRecipeInterceptors) {
			current = endpointHolder.endpoint().getAdditionIngredient(current);
		}
		return current;
	}

	public class_1856 applyCraftingRecipeInterceptorsForBase(class_1856 current) {
		for (SortableEndpointHolder<CraftingRecipeInterceptor> endpointHolder : craftingRecipeInterceptors) {
			current = endpointHolder.endpoint().getBaseIngredient(current);
		}
		return current;
	}

	@Deprecated(since = "1.4.0")
	public TrimPalette applyPaletteInterceptorsForGeneration(TrimPalette generated, class_8054 material) {
		for (SortableEndpointHolder<PaletteInterceptor> endpointHolder : paletteInterceptors) {
			generated = endpointHolder.endpoint().interceptGenerated(generated, material);
		}
		return generated;
	}

	@Deprecated(since = "1.4.0")
	public TrimPalette applyPaletteInterceptorsForMaterialAdditions(TrimPalette palette, MaterialAdditions additions) {
		for (SortableEndpointHolder<PaletteInterceptor> endpointHolder : paletteInterceptors) {
			palette = endpointHolder.endpoint().interceptMaterialAdditions(palette, additions);
		}
		return palette;
	}
}
