package com.bawnorton.trimica.client.mixin;

import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.data.tags.TrimicaTags;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9322;
import net.minecraft.class_9331;

@MixinEnvironment(value = "client", type = MixinEnvironment.Env.MAIN)
@Mixin(value = class_1799.class, priority = 1500)
public abstract class ItemStackMixin implements class_9322 {
	@Shadow
	public abstract boolean is(class_6862<class_1792> tag);

	@Definition(id = "TRIM", field = "Lnet/minecraft/core/component/DataComponents;TRIM:Lnet/minecraft/core/component/DataComponentType;")
	@Expression("this.?(TRIM, ?, ?, ?, ?)")
	@WrapOperation(
			method = "addDetailsToTooltip",
			at = @At("MIXINEXTRAS:EXPRESSION")
	)
	private <T> void addTrimicaAdditionLines(class_1799 instance, class_9331<T> component, class_1792.class_9635 context, class_10712 tooltipDisplay, Consumer<class_2561> tooltipAdder, class_1836 tooltipFlag, Operation<Void> original) {
		if (AdditionalTrims.enableAdditionalTrims) {
			List<class_8053> trims = AdditionalTrims.getAllTrims(this).reversed();
			if (!trims.isEmpty()) {
				tooltipAdder.accept(class_2561.method_43471(class_156.method_646("item", class_2960.method_60656("smithing_template.upgrade"))).method_27692(class_124.field_1080));
			}
			for (class_8053 trim : trims) {
				class_8056 pattern = trim.comp_3180().comp_349();
				class_8054 material = trim.comp_3179().comp_349();

				TrimPalette palette = TrimicaClient.getPalettes().getPalette(material, null, this);
				if (palette == null) palette = TrimPalette.DEFAULT;

				class_2583 style = material.comp_1212().method_10866();
				if (style.method_10973() == null || palette.isAnimated()) {
					style = style.method_36139(palette.getTooltipColour());
				}
				class_2561 patternComponent = class_5244.method_48320().method_10852(pattern.comp_1215().method_27661().method_27696(style));
				class_2561 materialComponent = class_5244.method_48320().method_10852(material.comp_1212().method_27661().method_27696(style));
				tooltipAdder.accept(patternComponent);
				tooltipAdder.accept(materialComponent);
			}
		} else {
			original.call(instance, component, context, tooltipDisplay, tooltipAdder, tooltipFlag);
		}
		if (MaterialAdditions.enableMaterialAdditions) {
			MaterialAdditions additions = method_58695(MaterialAdditions.TYPE, MaterialAdditions.NONE);
			List<class_2561> additionsList = new ArrayList<>();
			for (class_2960 addition : additions.additionKeys()) {
				class_1792 additionItem = class_7923.field_41178.method_63535(addition);
				if (additionItem != class_1802.field_8162) {
					additionsList.add(class_5244.method_48320().method_10852(additionItem.method_63680()).method_27692(class_124.field_1075));
				}
			}
			if (!additionsList.isEmpty()) {
				tooltipAdder.accept(class_2561.method_43471("trimica.material_addition_list").method_27692(class_124.field_1080));
				for (class_2561 addition : additionsList) {
					tooltipAdder.accept(addition);
				}
			}
		}
		if (is(TrimicaTags.MATERIAL_ADDITIONS) && MaterialAdditions.enableMaterialAdditions) {
			//? if >=1.21.10 {
			/*if (Minecraft.getInstance().hasShiftDown()) {
				*///?} else {
				if (class_437.method_25442()) {
				 //?}
				tooltipAdder.accept(class_2561.method_43471("trimica.material_addition.shift").method_27692(class_124.field_1065));
				tooltipAdder.accept(class_5244.method_48320().method_10852(class_2561.method_43471("trimica.material_addition.details.1").method_27692(class_124.field_1080)));
				tooltipAdder.accept(class_5244.method_48320().method_10852(class_2561.method_43471("trimica.material_addition.details.2").method_27692(class_124.field_1061)));
			} else {
				tooltipAdder.accept(class_2561.method_43471("trimica.material_addition.no_shift").method_27692(class_124.field_1065));
			}
		}
		if (is(class_3489.field_41891)) {
			tooltipAdder.accept(class_2561.method_43471("trimica.trim_material").method_27692(class_124.field_1060));
		}
	}
}