package com.bawnorton.trimica.client.mixin.render;

import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.mixin.accessor.EquipmentLayerRenderer$TrimSpriteKeyAccessor;
import com.bawnorton.trimica.client.mixin.accessor.EquipmentLayerRenderer.TrimSpriteKeyAccessor;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlas;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlases;
import com.bawnorton.trimica.client.texture.TrimArmourSpriteFactory;
import com.bawnorton.trimica.compat.Compat;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import net.minecraft.class_10186;
import net.minecraft.class_10197;
import net.minecraft.class_10209;
import net.minecraft.class_10394;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5321;
import net.minecraft.class_765;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9331;
import net.minecraft.client.renderer.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;

//? if >=1.21.10
/*import net.minecraft.client.renderer.feature.ModelFeatureRenderer;*/

@MixinEnvironment("client")
@Mixin(class_10197.class)
abstract class EquipmentLayerRendererMixin {
	@Shadow
	@Final
	private Function<class_10197.class_10199, class_1058> trimSpriteLookup;

	@WrapOperation(
			method = "<init>",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/Util;memoize(Ljava/util/function/Function;)Ljava/util/function/Function;",
					ordinal = 1
			)
	)
	private Function<class_10197.class_10199, class_1058> provideRuntimeTextures(Function<class_10197.class_10199, class_1058> textureGetter, Operation<Function<class_10197.class_10199, class_1058>> original) {
		return trimica$dynamicProvider(original.call(textureGetter));
	}

	@SuppressWarnings("resource")
	@Unique
	private static @NotNull Function<class_10197.class_10199, class_1058> trimica$dynamicProvider(Function<class_10197.class_10199, class_1058> textureGetter) {
		return trimSpriteKey -> {
			class_1058 sprite = textureGetter.apply(trimSpriteKey);
			class_3695 profiler = class_10209.method_64146();
			profiler.method_15396("trimica:armour_runtime_atlas");
			class_1799 stack = TrimArmourSpriteFactory.ITEM_WITH_TRIM_CAPTURE.get();
			MaterialAdditions addition = stack.method_58695(MaterialAdditions.TYPE, MaterialAdditions.NONE);
			if (!sprite.method_45851().method_45816().equals(class_1047.method_4539()) && addition.isEmpty()) return sprite;

			RuntimeTrimAtlases atlases = TrimicaClient.getRuntimeAtlases();
			class_8054 material = trimSpriteKey.comp_3199().comp_3179().comp_349();
			RuntimeTrimAtlas atlas = atlases.getEquipmentAtlas(class_310.method_1551().field_1687, material, trimSpriteKey.comp_3200());
			if (atlas == null) return sprite;

			class_2960 overlayLocation = trimSpriteKey.method_65573();
			overlayLocation = addition.apply(overlayLocation);
			class_8056 pattern = trimSpriteKey.comp_3199().comp_3180().comp_349();
			DynamicTrimTextureAtlasSprite dynamicSprite = atlas.getSprite(stack, pattern, overlayLocation);
			profiler.method_15407();
			return dynamicSprite;
		};
	}

	//? if >=1.21.10 {
	/*@ModifyReceiver(
			method = "renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Ljava/lang/Object;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;ILnet/minecraft/resources/ResourceLocation;II)V",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;"
			)
	)
	private <S> ItemStack captureItemWithTrimOrRenderAll(
			ItemStack instance,
			DataComponentType<?> dataComponentType,
			EquipmentClientInfo.LayerType layerType,
			ResourceKey<EquipmentAsset> equipmentAsset,
			Model<? super S> armorModel,
			S renderState,
			ItemStack item,
			PoseStack poseStack,
			SubmitNodeCollector nodeCollector,
			int packedLight,
			@Nullable ResourceLocation texture,
			int outlineColor,
			int key,
			@Cancellable CallbackInfo ci
	) {
		TrimArmourSpriteFactory.ITEM_WITH_TRIM_CAPTURE.set(instance);
		if (!AdditionalTrims.enableAdditionalTrims) {
			return instance;
		}

		ci.cancel();
		List<BiConsumer<Boolean, Boolean>> renderers = new ArrayList<>();
		boolean isEmissive = false;
		boolean isAnimated = false;
		List<ArmorTrim> trims = AdditionalTrims.getAllTrims(instance);
		for (ArmorTrim trim : trims) {
			TextureAtlasSprite sprite = trimSpriteLookup.apply(EquipmentLayerRenderer$TrimSpriteKeyAccessor.trimica$init(trim, layerType, equipmentAsset));
			TrimPalette palette;
			RenderType renderType;
			if (sprite instanceof DynamicTrimTextureAtlasSprite dynamicSprite) {
				palette = dynamicSprite.getPalette();
				if (palette != null) {
					if (palette.isAnimated()) isAnimated = true;
					if (palette.isEmissive()) isEmissive = true;
				}
				renderType = dynamicSprite.getRenderType();
			} else {
				renderType = Sheets.armorTrimsSheet(trim.pattern().value().decal());
			}
			AtomicInteger index = new AtomicInteger(key);
			renderers.add((emissive, animated) -> {
				if (animated) {
					Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(sprite));
				}
				nodeCollector.order(index.getAndIncrement())
						.submitModel(
								armorModel,
								renderState,
								poseStack,
								renderType,
								emissive ? LightTexture.FULL_BRIGHT : packedLight,
								OverlayTexture.NO_OVERLAY,
								-1,
								sprite,
								outlineColor,
								null
						);
			});
		}
		for (BiConsumer<Boolean, Boolean> renderer : renderers) {
			renderer.accept(isEmissive, isAnimated);
		}
		return instance;
	}

	@WrapOperation(
			method = "renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Ljava/lang/Object;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;ILnet/minecraft/resources/ResourceLocation;II)V",
			at = @At(
					value = "INVOKE:LAST",
					target = "Lnet/minecraft/client/renderer/OrderedSubmitNodeCollector;submitModel(Lnet/minecraft/client/model/Model;Ljava/lang/Object;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/RenderType;IIILnet/minecraft/client/renderer/texture/TextureAtlasSprite;ILnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;)V"
			)
	)
	private <S> void useDynamicRenderType(
			OrderedSubmitNodeCollector instance,
			Model<? super S> model,
			S renderState,
			PoseStack poseStack,
			RenderType renderType,
			int packedLight,
			int packedOverlay,
			int tintColor,
			TextureAtlasSprite textureAtlasSprite,
			int outlineColor,
			ModelFeatureRenderer.CrumblingOverlay crumblingOverlay,
			Operation<Void> original
	) {
		if (textureAtlasSprite instanceof DynamicTrimTextureAtlasSprite dynamicSprite) {
			TrimPalette palette = dynamicSprite.getPalette();
			if (palette != null && palette.isAnimated()) {
				Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(dynamicSprite));
			}
			original.call(instance,
					model,
					renderState,
					poseStack,
					dynamicSprite.getRenderType(),
					palette != null ? (palette.isEmissive() ? LightTexture.FULL_BRIGHT : packedLight) : packedLight,
					packedOverlay,
					tintColor,
					textureAtlasSprite,
					outlineColor,
					crumblingOverlay
			);
		} else {
			original.call(instance,
					model,
					renderState,
					poseStack,
					renderType,
					packedLight,
					packedOverlay,
					tintColor,
					textureAtlasSprite,
					outlineColor,
					crumblingOverlay
			);
		}
	}

	*///?} else {
	@ModifyReceiver(
			method = "renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;"
			)
	)
	private class_1799 captureItemWithTrimOrRenderAll(class_1799 instance, class_9331<?> dataComponentType,
	                                                 @Local(argsOnly = true) class_10186.class_10190 layerType,
	                                                 @Local(argsOnly = true) class_5321<class_10394> equipmentAsset,
	                                                 @Local(argsOnly = true) class_3879 armorModel,
	                                                 @Local(argsOnly = true) class_4587 poseStack,
	                                                 @Local(argsOnly = true) class_4597 bufferSource,
	                                                 @Local(argsOnly = true) int packedLight,
	                                                 @Cancellable CallbackInfo ci) {
		TrimArmourSpriteFactory.ITEM_WITH_TRIM_CAPTURE.set(instance);
		if (!AdditionalTrims.enableAdditionalTrims) {
			return instance;
		}

		ci.cancel();
		List<BiConsumer<Boolean, Boolean>> renderers = new ArrayList<>();
		boolean isEmissive = false;
		boolean isAnimated = false;
		List<class_8053> trims = AdditionalTrims.getAllTrims(instance);
		for (class_8053 trim : trims) {
			class_1058 sprite = trimSpriteLookup.apply(TrimSpriteKeyAccessor.trimica$init(trim, layerType, equipmentAsset));
			TrimPalette palette;
			class_1921 renderType;
			if (sprite instanceof DynamicTrimTextureAtlasSprite dynamicSprite) {
				palette = dynamicSprite.getPalette();
				if (palette != null) {
					if (palette.isAnimated()) isAnimated = true;
					if (palette.isEmissive()) isEmissive = true;
				}
				renderType = dynamicSprite.getRenderType();
			} else {
				renderType = class_4722.method_48480(trim.comp_3180().comp_349().comp_1905());
			}
			renderers.add((emissive, animated) -> {
				if (animated) {
					Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(sprite));
				}
				class_4588 vertexConsumer = sprite.method_24108(bufferSource.getBuffer(renderType));
				armorModel.method_60879(poseStack, vertexConsumer, emissive ? class_765.field_32767 : packedLight, class_4608.field_21444);
			});
		}
		for (BiConsumer<Boolean, Boolean> renderer : renderers) {
			renderer.accept(isEmissive, isAnimated);
		}
		return instance;
	}

	@WrapOperation(
			method = "renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/client/renderer/MultiBufferSource;getBuffer(Lnet/minecraft/client/renderer/RenderType;)Lcom/mojang/blaze3d/vertex/VertexConsumer;"
			)
	)
	private class_4588 useDynamicRenderType(class_4597 instance, class_1921 renderType, Operation<class_4588> original, @Local class_1058 textureAtlasSprite, @Share("palette") LocalRef<TrimPalette> paletteLocalRef) {
		if (textureAtlasSprite instanceof DynamicTrimTextureAtlasSprite dynamicSprite) {
			TrimPalette palette = dynamicSprite.getPalette();
			paletteLocalRef.set(palette);
			if (palette != null && palette.isAnimated()) {
				Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(dynamicSprite));
			}
			return original.call(instance, dynamicSprite.getRenderType());
		}
		return original.call(instance, renderType);
	}

	@WrapOperation(
			method = "renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/client/model/Model;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V"
			)
	)
	private void usePaletteLightness(class_3879 instance, class_4587 poseStack, class_4588 vertexConsumer, int i, int j, Operation<Void> original, @Share("palette") LocalRef<TrimPalette> paletteLocalRef) {
		TrimPalette palette = paletteLocalRef.get();
		int light = palette == null ? i : (palette.isEmissive() ? class_765.field_32767 : i);
		original.call(instance, poseStack, vertexConsumer, light, j);
	}
	//?}
}
