package com.bawnorton.trimica.loot;

import com.bawnorton.trimica.mixin.accessor.CompositeEntryBaseAccessor;
import com.bawnorton.trimica.mixin.accessor.DynamicLootAccessor;
import com.bawnorton.trimica.mixin.accessor.LootItemAccessor;
import com.bawnorton.trimica.mixin.accessor.LootPoolAccessor;
import com.bawnorton.trimica.mixin.accessor.LootTableAccessor;
import com.bawnorton.trimica.mixin.accessor.NestedLootTableAccessor;
import com.bawnorton.trimica.mixin.accessor.TagEntryAccessor;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2480;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_6862;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_8168;
import net.minecraft.class_85;

public class LootTableReader {
	public static List<class_1792> read(LootTableGetter getter, class_52 lootTable) {
		LootTableAccessor accessor = (LootTableAccessor) lootTable;
		List<class_55> pools = accessor.trimica$pools();
		List<class_1792> items = new ArrayList<>();
		for (class_55 pool : pools) {
			List<class_79> entries = ((LootPoolAccessor) pool).trimica$entries();
			for (class_79 entry : entries) {
				items.addAll(readEntry(getter, entry));
			}
		}
		return items;
	}

	private static List<class_1792> readEntry(LootTableGetter getter, class_79 entry) {
		return switch (entry) {
			case CompositeEntryBaseAccessor compositeEntryBase -> {
				List<class_1792> items = new ArrayList<>();
				for (class_79 lootPoolEntry : compositeEntryBase.trimica$children()) {
					items.addAll(readEntry(getter, lootPoolEntry));
				}
				yield items;
			}
			case class_85 singletonContainer -> switch (singletonContainer) {
				case DynamicLootAccessor dynamicLoot -> {
					class_2960 name = dynamicLoot.trimica$name();
					if (name.equals(class_8168.field_43236)) {
						yield List.of(class_1802.field_42699);
					} else if (name.equals(class_2480.field_11495)) {
						yield List.of(class_1802.field_8545);
					}
					yield List.of();
				}
				case LootItemAccessor lootItem -> List.of(lootItem.trimica$item().comp_349());
				case NestedLootTableAccessor nestedLootTable -> {
					Either<class_5321<class_52>, class_52> value = nestedLootTable.trimica$contents();
					class_52 table = value.map(key -> getter.get(key.method_29177()), Function.identity());
					if (table == null) yield List.of();

					yield read(getter, table);
				}
				case TagEntryAccessor tagEntry -> {
					class_6862<class_1792> tagKey = tagEntry.trimica$tag();
					List<class_1792> items = new ArrayList<>();
					class_7923.field_41178.method_46733(tagKey).ifPresent(named -> named.forEach(holder -> items.add(holder.comp_349())));
					yield items;
				}
				default -> List.of();
			};
			default -> List.of();
		};
	}

	public interface LootTableGetter {
		class_52 get(class_2960 id);
	}
}
