package com.bawnorton.trimica.mixin.loot;

import com.bawnorton.trimica.TrimicaToggles;
import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.item.TrimicaItems;
import com.bawnorton.trimica.loot.LootTableReader;
import com.bawnorton.trimica.mixin.accessor.LootTable$BuilderAccessor;
import com.bawnorton.trimica.mixin.accessor.LootTable.BuilderAccessor;
import com.bawnorton.trimica.mixin.accessor.LootTableAccessor;
import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_73;
import net.minecraft.class_77;
import net.minecraft.class_8052;
import net.minecraft.class_9383;

@Mixin(class_9383.class)
abstract class ReloadableServerRegistriesMixin {
	@SuppressWarnings({"unchecked", "ConstantValue"})
	@ModifyReceiver(
			//? if fabric {
			method = "method_61240",
			//?} else {
			/*method = "lambda$scheduleRegistryLoad$5",
			*///?}
			at = @At(
					value = "INVOKE",
					target = "Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V"
			)
	)
	private static <T> Map<class_2960, T> modifyLootTables(Map<class_2960, T> instance, BiConsumer<class_2960, T> consumer) {
		if (!TrimicaToggles.enableItems || !TrimicaToggles.enableAnimator) return instance;

		int counter = 0;
		for (Map.Entry<class_2960, T> entry : instance.entrySet()) {
			T value = entry.getValue();
			if (!(value instanceof class_52 lootTable)) continue;

			List<class_1792> items = LootTableReader.read(rl -> (class_52) instance.get(rl), lootTable);
			boolean containsTemplateItem = items.stream().anyMatch(item -> item instanceof class_8052);
			if (containsTemplateItem) {
				class_52.class_53 builder = new class_52.class_53();
				LootTableAccessor accessor = (LootTableAccessor) lootTable;
				BuilderAccessor builderAccessor = (BuilderAccessor) builder;
				builder.method_334(lootTable.method_322());
				builderAccessor.trimica$pools(ImmutableList.<class_55>builder().addAll(accessor.trimica$pools()));
				builderAccessor.trimica$functions(ImmutableList.<class_117>builder().addAll(accessor.trimica$functions()));
				accessor.trimica$randomSequence().ifPresent(builder::method_51883);

				builder.method_336(class_55.method_347()
						.method_352(class_44.method_32448(1))
						.method_351(class_77.method_411(TrimicaItems.ANIMATOR))
						.method_351(class_73.method_401().method_437(15)));
				instance.put(entry.getKey(), (T) builder.method_338());
				counter++;
			}
		}
		if (counter > 0) {
			Trimica.LOGGER.info("Added Trimica's Animator to {} loot tables", counter);
		}
		return instance;
	}
}
