/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.command;

import com.bawnorton.configurable.api.ConfigurableApi;
import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.ComponentUtil;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10192;
import net.minecraft.class_10711;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2379;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_9334;

public class TrimicaCommandManager {
    public static void init(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trimica").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").requires(source -> source.method_9259(4))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"summon").then(class_2170.method_9247((String)"all").executes(context -> {
            TrimicaCommandManager.summonArmourStands((CommandContext<class_2168>)context, true);
            return 1;
        }))).executes(context -> TrimicaCommandManager.summonArmourStands((CommandContext<class_2168>)context, false))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"toggle").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"configEntry", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(List.of("trimEverything", "materialAdditions", "perPatternItemTextures", "additionalTrims"), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(List.of("true", "false"), (SuggestionsBuilder)builder)).executes(TrimicaCommandManager::setConfigValue)))));
    }

    private static int summonArmourStands(CommandContext<class_2168> context, boolean allMaterials) {
        class_2168 source = (class_2168)context.getSource();
        class_5455 registryAccess = source.method_30497();
        class_2378 patternLookup = registryAccess.method_30530(class_7924.field_42082);
        class_3218 level = source.method_9225();
        class_2338.class_2339 pos = class_2338.method_49638((class_2374)source.method_9222()).method_25503();
        List<Object> materials = allMaterials ? registryAccess.method_30530(class_7924.field_41197).method_42017().map(itemRef -> {
            class_1792 item = (class_1792)itemRef.comp_349();
            class_10711 trimMaterialProvider = (class_10711)item.method_7854().method_58694(class_9334.field_56397);
            if (trimMaterialProvider == null) {
                return null;
            }
            return trimMaterialProvider.comp_3599().method_60739((class_7225.class_7874)registryAccess).orElse(null);
        }).filter(Objects::nonNull).toList() : registryAccess.method_30530(class_7924.field_42083).method_42017().toList();
        source.method_45068((class_2561)class_2561.method_43470((String)"Summoning %s armour stands at %s".formatted(patternLookup.method_46754().count() * (long)materials.size(), pos.method_23854())));
        Object ref = new Object(){
            boolean flag = false;
        };
        patternLookup.method_42017().forEach(arg_0 -> TrimicaCommandManager.lambda$summonArmourStands$10(materials, level, pos, ref, arg_0));
        return 1;
    }

    private static int setConfigValue(CommandContext<class_2168> context) {
        boolean newValue;
        class_2168 source = (class_2168)context.getSource();
        String configEntry = StringArgumentType.getString(context, (String)"configEntry");
        String value = StringArgumentType.getString(context, (String)"value");
        try {
            newValue = Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid value: %s. Must be 'true' or 'false'.".formatted(value)));
            return 0;
        }
        switch (configEntry) {
            case "trimEverything": {
                TrimMaterialRuntimeRegistry.enableTrimEverything = newValue;
                ConfigurableApi.saveChanges((class_3218)source.method_9225(), (boolean)true);
                break;
            }
            case "materialAdditions": {
                MaterialAdditions.enableMaterialAdditions = newValue;
                ConfigurableApi.saveChanges((class_3218)source.method_9225(), (boolean)true);
                break;
            }
            case "perPatternItemTextures": {
                Trimica.enablePerPatternItemTextures = newValue;
                ConfigurableApi.saveChanges((class_3218)source.method_9225(), (boolean)true);
                break;
            }
            case "additionalTrims": {
                AdditionalTrims.enableAdditionalTrims = newValue;
                ConfigurableApi.saveChanges((class_3218)source.method_9225(), (boolean)true);
                break;
            }
            default: {
                source.method_9213((class_2561)class_2561.method_43470((String)"Unknown config entry: %s".formatted(configEntry)));
                return 0;
            }
        }
        source.method_9226(() -> class_2561.method_43470((String)"Set %s to %s".formatted(configEntry, value)), true);
        return 1;
    }

    private static /* synthetic */ void lambda$summonArmourStands$10(List materials, class_3218 level, class_2338.class_2339 pos, 1 ref, class_6880.class_6883 patternRef) {
        materials.forEach(materialRef -> {
            List<class_1799> toEquip = ComponentUtil.getTrimmedEquipment(new class_8053(materialRef, (class_6880)patternRef));
            class_1531 stand = (class_1531)class_1299.field_6131.method_5888(level, armourStand -> {
                armourStand.method_5875(true);
                armourStand.method_6907(true);
                armourStand.method_6913(true);
                armourStand.method_60608(0.0f, 0.0f);
                armourStand.method_6910(new class_2379(-70.0f, 80.0f, -20.0f));
                toEquip.forEach(stack -> {
                    class_10192 equippable = (class_10192)stack.method_58694(class_9334.field_54196);
                    assert (equippable != null);
                    armourStand.method_5673(equippable.comp_3174(), stack);
                });
            }, (class_2338)pos, class_3730.field_16471, false, false);
            if (stand != null) {
                level.method_8649((class_1297)stand);
            }
            pos.method_10104(class_2350.field_11034, 2);
        });
        pos.method_10104(class_2350.field_11039, 2 * materials.size());
        pos.method_10098(class_2350.field_11036);
        ref.flag = !ref.flag;
        if (ref.flag) {
            pos.method_10098(class_2350.field_11039);
        } else {
            pos.method_10098(class_2350.field_11034);
        }
        pos.method_10098(class_2350.field_11043);
    }
}

