/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.compat.elytratrims;

import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlas;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlases;
import com.bawnorton.trimica.compat.Compat;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import dev.kikugie.elytratrims.api.ETClientInitializer;
import dev.kikugie.elytratrims.api.render.ETRenderParameters;
import dev.kikugie.elytratrims.api.render.ETRendererID;
import dev.kikugie.elytratrims.api.render.ETRenderingAPI;
import dev.kikugie.elytratrims.api.render.ETRenderingAPIUtils;
import dev.kikugie.elytratrims.render.impl.ETTrimsRenderer;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_10186;
import net.minecraft.class_10191;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_918;
import net.minecraft.class_9473;

public class ElytraTrimsClientEntrypoint
implements ETClientInitializer {
    public void onInitializeClientET() {
        ETRenderingAPI.wrapRenderCall((ETRendererID)ETTrimsRenderer.type, this::renderWithTrimica);
    }

    private boolean renderWithTrimica(ETRenderParameters parameters, Function<ETRenderParameters, Boolean> original) {
        Supplier<Boolean> callOriginal = () -> (Boolean)original.apply(parameters);
        class_1799 stack = parameters.stack();
        List<class_8053> trims = AdditionalTrims.getAllTrims((class_9473)stack);
        if (trims.isEmpty()) {
            return callOriginal.get();
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return callOriginal.get();
        }
        for (class_8053 trim : trims) {
            this.renderWithTrimicaInternal(level, stack, trim, parameters, callOriginal::get, (sprite, light) -> {
                class_4588 vertexConsumer = sprite.method_24108(class_918.method_27952((class_4597)parameters.source(), (class_1921)sprite.getRenderType(), (boolean)stack.method_7958()));
                class_3879 elytra = parameters.elytra();
                elytra.method_62100(parameters.matrices(), vertexConsumer, light, class_4608.field_21444, parameters.color());
            });
        }
        return false;
    }

    private void renderWithTrimicaInternal(class_638 level, class_1799 stack, class_8053 trim, ETRenderParameters parameters, Runnable original, Renderer renderer) {
        class_8056 pattern;
        DynamicTrimTextureAtlasSprite newSprite;
        TrimPalette palette;
        class_8054 material;
        RuntimeTrimAtlases atlases = TrimicaClient.getRuntimeAtlases();
        RuntimeTrimAtlas atlas = atlases.getEquipmentAtlas(level, material = (class_8054)trim.comp_3179().comp_349(), class_10186.class_10190.field_54127);
        if (atlas == null) {
            return;
        }
        class_2960 overlayLocation = trim.method_67225(class_10186.class_10190.field_54127.method_67293(), class_10191.field_54142);
        if (MaterialAdditions.enableMaterialAdditions) {
            MaterialAdditions additions = (MaterialAdditions)stack.method_58695(MaterialAdditions.TYPE, (Object)MaterialAdditions.NONE);
            overlayLocation = additions.apply(overlayLocation);
        }
        if ((palette = (newSprite = atlas.getSprite((class_9473)stack, pattern = (class_8056)trim.comp_3180().comp_349(), overlayLocation)).getPalette()) == null) {
            original.run();
            return;
        }
        if (palette.isAnimated()) {
            Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(newSprite));
        }
        int light = palette.isEmissive() ? 0xF000F0 : ETRenderingAPIUtils.getEffectiveLight((ETRenderParameters)parameters);
        renderer.render(newSprite, light);
    }

    static interface Renderer {
        public void render(DynamicTrimTextureAtlasSprite var1, int var2);
    }
}

