package com.bawnorton.trimica.client.mixin;

import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5251;
import net.minecraft.class_6880;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_9473;

@MixinEnvironment(value = "client", type = MixinEnvironment.Env.MAIN)
@Mixin(class_8053.class)
public abstract class ArmorTrimMixin {
	@Shadow
	public abstract class_6880<class_8054> material();

	@ModifyArg(
			method = "addToTooltip",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/network/chat/MutableComponent;append(Lnet/minecraft/network/chat/Component;)Lnet/minecraft/network/chat/MutableComponent;"
			)
	)
	private class_2561 correctMaterialColour(class_2561 original, @Local(argsOnly = true) class_9473 componentGetter) {
		TrimPalette palette = TrimicaClient.getPalettes().getPalette(material().comp_349(), null, componentGetter);
		if (palette == null) return original;

		if (palette.isAnimated()) {
			return original.method_27661().method_54663(palette.getTooltipColour());
		} else {
			class_5251 color = original.method_10866().method_10973();
			if (color == null) {
				return original.method_27661().method_54663(palette.getTooltipColour());
			}
		}
		return original;
	}

	@WrapWithCondition(
			method = "addToTooltip",
			at = @At(
					value = "INVOKE",
					target = "Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V"
			)
	)
	private <T> boolean dontAddToTooltipIfAdditionalTrimsEnabled(Consumer<T> instance, T t) {
		return !AdditionalTrims.enableAdditionalTrims;
	}

	@Inject(
			method = "addToTooltip",
			at = @At("RETURN")
	)
	private void addAdditionLines(class_1792.class_9635 tooltipContext, Consumer<class_2561> consumer, class_1836 tooltipFlag, class_9473 componentGetter, CallbackInfo ci) {
		if (!TrimMaterialRuntimeRegistry.enableTrimEverything) {
			TrimPalette palette = TrimicaClient.getPalettes().getPalette(material().comp_349(), null, componentGetter);
			if (palette == TrimPalette.DISABLED) {
				consumer.accept(class_5244.method_48320().method_10852(class_2561.method_43471("trimica.trim_material.disabled").method_27692(class_124.field_1061)));
			}
		}
	}
}
