package com.bawnorton.trimica.client.mixin.render;

import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.compat.Compat;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_10209;
import net.minecraft.class_10509;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_600;
import net.minecraft.class_765;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9323;

//? if >=1.21.10
/*import net.minecraft.client.renderer.SubmitNodeCollector;*/

@MixinEnvironment(value = "client")
@Mixin(class_10509.class)
public abstract class ShieldSpecialRendererMixin {
	@Shadow
	@Final
	private class_600 model;

	//? if >=1.21.10 {
	/*@Inject(
			method = "submit(Lnet/minecraft/core/component/DataComponentMap;Lnet/minecraft/world/item/ItemDisplayContext;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;IIZI)V",
			at = @At(
					value = "INVOKE",
					target = "Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V"
			)
	)
	private void submitTrim(DataComponentMap argument, ItemDisplayContext displayContext, PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, int packedOverlay, boolean hasFoil, int outlineColor, CallbackInfo ci) {
		ProfilerFiller profiler = Profiler.get();
		profiler.push("trimica:shield");
		List<DynamicTrimTextureAtlasSprite> dynamicSprites = TrimicaClient.getRuntimeAtlases().getShieldSprites(Minecraft.getInstance().level, argument);
		for (DynamicTrimTextureAtlasSprite dynamicSprite : dynamicSprites) {
			TrimPalette palette = dynamicSprite.getPalette();
			int light = palette == null ? packedLight : (palette.isEmissive() ? LightTexture.FULL_BRIGHT : packedLight);
			if (palette != null && palette.isAnimated()) {
				Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(dynamicSprite));
			}
			nodeCollector.submitModelPart(
					this.model.plate(),
					poseStack,
					dynamicSprite.getRenderType(),
					light,
					packedOverlay,
					dynamicSprite,
					false,
					hasFoil,
					-1,
					null,
					outlineColor
			);
		}

		profiler.pop();
	}
	*///?} else {
	@Inject(
			method = "render(Lnet/minecraft/core/component/DataComponentMap;Lnet/minecraft/world/item/ItemDisplayContext;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IIZ)V",
			at = @At(
					value = "INVOKE",
					target = "Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V"
			)
	)
	private void renderTrim(class_9323 dataComponentMap, class_811 itemDisplayContext, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, boolean bl, CallbackInfo ci) {
		class_3695 profiler = class_10209.method_64146();
		profiler.method_15396("trimica:shield");
		List<DynamicTrimTextureAtlasSprite> dynamicSprites = TrimicaClient.getRuntimeAtlases().getShieldSprites(class_310.method_1551().field_1687, dataComponentMap);
		for (DynamicTrimTextureAtlasSprite dynamicSprite : dynamicSprites) {
			TrimPalette palette = dynamicSprite.getPalette();
			int light = palette == null ? i : (palette.isEmissive() ? class_765.field_32767 : i);
			if (palette != null && palette.isAnimated()) {
				Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(dynamicSprite));
			}
			class_4588 vertexConsumer = dynamicSprite.method_24108(class_918.method_23181(multiBufferSource, dynamicSprite.getRenderType(), itemDisplayContext == class_811.field_4317, bl));
			this.model.method_23774().method_22698(poseStack, vertexConsumer, light, j);
		}

		profiler.method_15407();
	}
	//?}
}
