package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.api.impl.TrimicaApiImpl;
import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.trim.TrimmedType;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_10192;
import net.minecraft.class_10394;
import net.minecraft.class_10539;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9334;
import net.minecraft.class_9473;

public class TrimItemSpriteFactory extends AbstractTrimSpriteFactory {
	public TrimItemSpriteFactory() {
		super(16, 16);
	}

	@Override
	protected @Nullable TrimSpriteMetadata getSpriteMetadata(class_8053 trim, @Nullable class_9473 componentGetter, class_2960 texture) {
		if (!(componentGetter instanceof class_1799 stack)) return null;

		TrimmedType trimmedType = TrimmedType.of(stack);
		class_5321<class_10394> assetResourceKey = Optional.ofNullable(stack.method_58694(class_9334.field_54196))
				.flatMap(class_10192::comp_3176)
				.orElse(null);
		class_8054 material = trim.comp_3179().comp_349();
		TrimPalette palette = TrimicaClient.getPalettes()
				.getOrGeneratePalette(material, assetResourceKey, componentGetter);
		class_2960 basePatternTexture;
		if (Trimica.enablePerPatternItemTextures) {
			basePatternTexture = TrimicaApiImpl.INSTANCE.applyBaseTextureInterceptorsForItem(getPatternBasedTrimOverlay(trimmedType, trim), stack, trim);
		} else {
			basePatternTexture = getDefaultTrimOverlay(trimmedType);
		}
		if(basePatternTexture == null) {
			Trimica.LOGGER.error("Provided base pattern texture for trim overlay is null: Pattern[{}]", trim.comp_3180().method_40230().orElse(null));
			return null;
		}

		return new TrimSpriteMetadata(trim, palette, basePatternTexture, trimmedType);
	}

	@Override
	protected class_1011 createImageFromMetadata(TrimSpriteMetadata metadata) {
		class_10539 contents = textureCache.computeIfAbsent(metadata.baseTexture(), k -> {
			try {
				return class_10539.method_65871(class_310.method_1551().method_1478(), k);
			} catch (IOException e) {
				TrimmedType trimmedType = metadata.trimmedType();
				class_2960 defaultTexture = getDefaultTrimOverlay(trimmedType);
				try {
					return class_10539.method_65871(class_310.method_1551().method_1478(), defaultTexture);
				} catch (IOException ex) {
					ex.addSuppressed(e);
					Trimica.LOGGER.warn("Expected to find \"{}\" but the texture does of exist, trim overlay will not be added to model", metadata.baseTexture());
					return new class_10539(empty(), null);
				}
			}
		});
		return createColouredImage(metadata, contents);
	}

	private class_2960 getPatternBasedTrimOverlay(TrimmedType trimmedType, class_8053 trim) {
		class_2960 location = trim.comp_3180()
				.method_40229()
				.map(class_5321::method_29177, class_8056::comp_1213);
		return Trimica.rl("textures/trims/items/%s/%s/%s.png".formatted(
				trimmedType.getName(),
				location.method_12836(),
				location.method_12832()
		));
	}

	private class_2960 getDefaultTrimOverlay(TrimmedType trimmedType) {
		if(trimmedType.isOfArmour()) {
			return class_2960.method_60656("textures/trims/items/%s_trim.png".formatted(trimmedType.getName()));
		} else {
			return Trimica.rl("textures/trims/items/%s/default.png".formatted(trimmedType.getName()));
		}
	}
}