package com.bawnorton.trimica.data.provider;

import com.bawnorton.trimica.data.tags.ConventionalTags;
import com.bawnorton.trimica.extend.TagAppenderExtension;
import com.bawnorton.trimica.item.TrimicaItems;
import com.bawnorton.trimica.data.tags.TrimicaTags;
import java.util.List;
import net.minecraft.class_11389;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;

public interface TrimicaItemTagProvider {
	default void addTags(class_7225.class_7874 provider) {
		addToTag(class_3489.field_41891, TrimicaItems.RAINBOWIFIER);
		addToTag(TrimicaTags.MATERIAL_ADDITIONS, TrimicaItems.ANIMATOR, class_1802.field_28410);
		addToTag(TrimicaTags.SMITHING_BASE_BLACKLIST, List.of(class_3489.field_48298, class_3489.field_15542, ConventionalTags.EMPTY_BUCKETS));
		addToTag(TrimicaTags.SMITHING_BASE_BLACKLIST, class_1802.field_17519);
		addToTag(TrimicaTags.SMITHING_ADDITION_BLACKLIST, class_1802.field_8162);
		addToTag(TrimicaTags.ALL_TRIMMABLES, class_3489.field_41890);
	}

	class_11389<class_1792, class_1792> tag(class_6862<class_1792> tagKey);

	default void addToTag(class_6862<class_1792> tagKey, class_1792... items) {
		tag(tagKey).method_71558(items);
	}

	@SuppressWarnings("unchecked")
	default void addToTag(class_6862<class_1792> tagKey, class_6862<class_1792> tag) {
		((TagAppenderExtension<class_5321<class_1792>, class_1792>) tag(tagKey)).trimica$forceAddTag(tag);
	}

	@SuppressWarnings("unchecked")
	default void addToTag(class_6862<class_1792> tagKey, List<class_6862<class_1792>> tags) {
		TagAppenderExtension<class_5321<class_1792>, class_1792> appender = (TagAppenderExtension<class_5321<class_1792>, class_1792>) tag(tagKey);
		for (class_6862<class_1792> tag : tags) {
			appender.trimica$forceAddTag(tag);
		}
	}
}
