package com.bawnorton.trimica.data.provider;

import com.bawnorton.trimica.data.recipe.MaterialAdditionRecipeBuilder;
import com.bawnorton.trimica.data.tags.ConventionalTags;
import com.bawnorton.trimica.data.tags.TrimicaTags;
import com.bawnorton.trimica.item.TrimicaItems;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_2066;
import net.minecraft.class_2447;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_7924;
import net.minecraft.class_8790;

public interface TrimicaRecipeProvider {
	default void buildRecipes(class_8790 output) {
		materialAdditionRecipe(output, TrimicaTags.ALL_TRIMMABLES, TrimicaTags.MATERIAL_ADDITIONS);
		shaped(class_7800.field_40642, TrimicaItems.RAINBOWIFIER, 1)
				.method_10433('R', ConventionalTags.RED_DYES)
				.method_10433('O', ConventionalTags.ORANGE_DYES)
				.method_10433('Y', ConventionalTags.YELLOW_DYES)
				.method_10433('G', ConventionalTags.LIME_DYES)
				.method_10433('C', ConventionalTags.CYAN_DYES)
				.method_10433('B', ConventionalTags.BLUE_DYES)
				.method_10433('I', ConventionalTags.PURPLE_DYES)
				.method_10433('V', ConventionalTags.PINK_DYES)
				.method_10434('X', TrimicaItems.ANIMATOR)
				.method_10439("ROY")
				.method_10439("VXG")
				.method_10439("IBC")
				.method_10429("has_ingredients", has(ConventionalTags.DYES))
				.method_10431(output);
	}

	default void materialAdditionRecipe(class_8790 output, class_6862<class_1792> baseTag, class_6862<class_1792> additionTag) {
		MaterialAdditionRecipeBuilder.materialAddition(class_7800.field_40642, tag(baseTag), tag(additionTag))
				.unlocks("has_ingredients", has(additionTag))
				.save(output, class_5321.method_29179(
						class_7924.field_52178,
						additionTag.comp_327()
				));
	}

	class_2447 shaped(class_7800 recipeCategory, class_1792 rainbowifier, int count);

	class_175<class_2066.class_2068> has(class_6862<class_1792> tag);

	class_1856 tag(class_6862<class_1792> tagKey);
}