package com.bawnorton.trimica.item.crafting;

import com.bawnorton.trimica.api.CraftingRecipeInterceptor;
import com.bawnorton.trimica.platform.Platform;
import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import com.bawnorton.trimica.data.tags.TrimicaTags;

public class DefaultCraftingRecipeInterceptor implements CraftingRecipeInterceptor {
	@Override
	public class_1856 getAdditionIngredient(class_1856 current) {
		return class_1856.method_26964(class_7923.field_41178.method_10220().filter(this::allowAsAddition));
	}

	private boolean allowAsAddition(class_1792 item) {
		class_6885<class_1792> blacklisted = getTag(TrimicaTags.SMITHING_ADDITION_BLACKLIST);
		return !blacklisted.method_40241(item.method_40131());
	}

	@Override
	public class_1856 getBaseIngredient(class_1856 current) {
		return class_1856.method_26964(class_7923.field_41178.method_10220().filter(this::allowAsBase));
	}

	private boolean allowAsBase(class_1792 item) {
		class_9323 components = item.method_57347();
		class_10192 equippable = components.method_58694(class_9334.field_54196);
		if (equippable == null) return false;

		class_6885<class_1792> blacklisted = getTag(TrimicaTags.SMITHING_BASE_BLACKLIST);
		if (blacklisted.method_40241(item.method_40131())) return false;
		if (!Platform.isModLoaded("elytratrims") && item == class_1802.field_8833) return false;

		class_1304 slot = equippable.comp_3174();
		return slot == class_1304.field_6169 || slot == class_1304.field_6174 || slot == class_1304.field_6172 || slot == class_1304.field_6166 || item == class_1802.field_8255;
	}
}
