package com.bawnorton.trimica.mixin.crafting;

import com.bawnorton.trimica.api.impl.TrimicaApiImpl;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8055;
import net.minecraft.class_8056;
import net.minecraft.class_8062;
import net.minecraft.class_9334;

@Mixin(class_8062.class)
public abstract class SmithingTrimRecipeMixin {
	@Shadow
	@Final
	@Mutable
	class_1856 addition;

	@Shadow
	@Final
	@Mutable
	class_1856 base;

	@Inject(
			method = "<init>",
			at = @At("TAIL")
	)
	private void useTrimicaIngredients(CallbackInfo ci) {
		if (TrimMaterialRuntimeRegistry.enableTrimEverything) {
			addition = TrimicaApiImpl.INSTANCE.applyCraftingRecipeInterceptorsForAddition(addition);
			base = TrimicaApiImpl.INSTANCE.applyCraftingRecipeInterceptorsForBase(base);
		}
	}

	@WrapMethod(
			method = "applyTrim"
	)
	private static class_1799 applyAdditionalTrims(class_7225.class_7874 registries, class_1799 base, class_1799 addition, class_6880<class_8056> pattern, Operation<class_1799> original) {
		if (!AdditionalTrims.enableAdditionalTrims) {
			return original.call(registries, base, addition, pattern);
		}

		AdditionalTrims.correctTrimComponents(base);
		class_8053 existingTrim = base.method_58694(class_9334.field_49607);
		if (existingTrim == null) {
			return original.call(registries, base, addition, pattern);
		}

		Optional<class_6880<class_8054>> optionalMaterial = class_8055.method_48440(registries, addition);
		if (optionalMaterial.isEmpty()) {
			return class_1799.field_8037;
		}

		class_6880<class_8054> material = optionalMaterial.get();
		class_8053 newTrim = new class_8053(material, pattern);
		if (AdditionalTrims.hasTrim(base, newTrim)) {
			return class_1799.field_8037;
		}

		class_1799 result = base.method_46651(1);
		if (AdditionalTrims.tryAddTrim(result, newTrim)) {
			return result;
		} else {
			return class_1799.field_8037;
		}
	}
}
