package com.bawnorton.trimica.trim;

import com.bawnorton.trimica.data.tags.ConventionalTags;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_9334;

public enum TrimmedType {
	HELMET,
	CHESTPLATE,
	LEGGINGS,
	BOOTS,
	SHIELD,
	UNKNOWN;

	public String getName() {
		return name().toLowerCase(Locale.ENGLISH);
	}

	public boolean isOfArmour() {
		return this == HELMET || this == CHESTPLATE || this == LEGGINGS || this == BOOTS;
	}

	public static TrimmedType of(class_1799 stack) {
		class_1304 slot = Optional.ofNullable(stack.method_58694(class_9334.field_54196))
				.map(class_10192::comp_3174)
				.orElse(null);
		return switch (slot) {
			case field_6166 -> TrimmedType.BOOTS;
			case field_6172 -> TrimmedType.LEGGINGS;
			case field_6174 -> TrimmedType.CHESTPLATE;
			case field_6169 -> TrimmedType.HELMET;
			case null, default -> {
				if (stack.method_31573(ConventionalTags.SHIELD_TOOLS)) {
					yield TrimmedType.SHIELD;
				} else {
					yield TrimmedType.UNKNOWN;
				}
			}
		};
	}
}