/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.data.tags;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.mixin.accessor.HolderSet$NamedAccessor;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import com.mojang.serialization.Lifecycle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterial;

public final class TrimicaRuntimeTags {
    private final Set<UnboundTag> unboundTags = new HashSet<UnboundTag>();
    private final Map<String, Holder.Reference<TrimMaterial>> references = new HashMap<String, Holder.Reference<TrimMaterial>>();

    public KeyHolder createMaterialKeyHolderForItem(Holder.Reference<Item> item) {
        ResourceLocation id = item.key().location();
        ResourceLocation generatedId = Trimica.rl("generated/%s/%s".formatted(id.getNamespace(), id.getPath()));
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)generatedId);
        return new KeyHolder((ResourceKey<TrimMaterial>)resourceKey, (TagKey<TrimMaterial>)TagKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)generatedId));
    }

    public Holder.Reference<TrimMaterial> createMaterialTagForItem(Holder.Reference<Item> itemRef, WritableRegistry<TrimMaterial> registry) {
        Item item = (Item)itemRef.value();
        ItemStack stack = item.getDefaultInstance();
        ProvidesTrimMaterial materialProvider = (ProvidesTrimMaterial)stack.get(DataComponents.PROVIDES_TRIM_MATERIAL);
        if (materialProvider == null) {
            if (TrimMaterialRuntimeRegistry.enableTrimEverything) {
                Trimica.LOGGER.warn("Item \"{}\" does not provide a trim material, cannot create runtime tag for it", itemRef);
            }
            return null;
        }
        Holder materialHolder = (Holder)materialProvider.material().contents().map(Function.identity(), key -> {
            Holder.Reference ref = registry.get(key).orElse(null);
            if (ref == null) {
                Trimica.LOGGER.warn("Item \"{}\" tried to provide a trim material which does not exist, cannot create runtime tag for it", (Object)itemRef);
                return null;
            }
            return ref;
        });
        if (materialHolder == null) {
            return null;
        }
        TrimMaterial material = (TrimMaterial)materialHolder.unwrap().map(arg_0 -> registry.getValue(arg_0), Function.identity());
        if (material == null) {
            Trimica.LOGGER.warn("Item \"{}\"'s trim material doesn't exist, cannot create runtime tag for it", itemRef);
            return null;
        }
        KeyHolder keyHolder = this.createMaterialKeyHolderForItem(itemRef);
        RegistrationInfo registrationInfo = new RegistrationInfo(Optional.empty(), Lifecycle.stable());
        ResourceKey<TrimMaterial> resourceKey = keyHolder.resourceKey();
        Holder.Reference reference = registry.getResourceKey((Object)material).flatMap(arg_0 -> registry.get(arg_0)).orElseGet(() -> registry.get(resourceKey).orElseGet(() -> registry.register(resourceKey, (Object)material, registrationInfo)));
        this.references.put(Trimica.getMaterialRegistry().getSuffix(material), (Holder.Reference<TrimMaterial>)reference);
        this.unboundTags.add(new UnboundTag(keyHolder.tagKey(), (Holder.Reference<TrimMaterial>)reference));
        Trimica.getMaterialRegistry().registerMaterialReference((Holder.Reference<TrimMaterial>)reference);
        return reference;
    }

    public Set<HolderSet.Named<TrimMaterial>> bindTags(Registry<TrimMaterial> registry) {
        HashSet<HolderSet.Named<TrimMaterial>> runtimeMaterialTags = new HashSet<HolderSet.Named<TrimMaterial>>();
        for (UnboundTag unboundTag : this.unboundTags) {
            HolderSet.Named<TrimMaterial> holderSet = HolderSet$NamedAccessor.trimica$init(registry, unboundTag.key());
            HolderSet$NamedAccessor accessor = (HolderSet$NamedAccessor)holderSet;
            accessor.trimica$bind(List.of(unboundTag.material()));
            runtimeMaterialTags.add(holderSet);
        }
        return runtimeMaterialTags;
    }

    public void clear() {
        this.clearUnbound();
        this.references.clear();
    }

    public void clearUnbound() {
        this.unboundTags.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Holder<TrimMaterial> convertHolder(Holder<TrimMaterial> holder) {
        TrimMaterial material;
        if (!(holder instanceof Holder.Direct)) return holder;
        Holder.Direct direct = (Holder.Direct)holder;
        try {
            TrimMaterial trimMaterial;
            material = trimMaterial = (TrimMaterial)direct.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        String suffix = Trimica.getMaterialRegistry().getSuffix(material);
        return Objects.requireNonNullElse((Holder)this.references.get(suffix), holder);
    }

    public record KeyHolder(ResourceKey<TrimMaterial> resourceKey, TagKey<TrimMaterial> tagKey) {
    }

    private record UnboundTag(TagKey<TrimMaterial> key, Holder.Reference<TrimMaterial> material) {
    }
}

