/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.generated.trimica;

import com.bawnorton.configurable.io.FileType;
import com.bawnorton.configurable.io.SaveLoader;
import com.bawnorton.configurable.reference.FieldReference;
import com.bawnorton.configurable.reference.validator.ValidatorReference;
import com.bawnorton.configurable.service.ConfigLoader;
import com.bawnorton.configurable.util.GenericType;
import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.TrimicaToggles;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@AutoService(value={ConfigLoader.class})
public final class GeneratedConfigLoader
implements ConfigLoader {
    public static final FieldReference<Boolean> enableAdditionalTrims = FieldReference.builder(value -> {
        AdditionalTrims.enableAdditionalTrims = value;
    }, () -> AdditionalTrims.enableAdditionalTrims, (GenericType)new GenericType(Boolean.class, new GenericType[0]), (String)"enable_additional_trims").doesSync(true).comment("Whether you can add trims to already trimmed armor.").onSet(Trimica::refreshEverything).validator(ValidatorReference.builder().messageProvider(ignored -> "Value for 'enable_additional_trims' is invalid. Resetting to default value: 'false'").fallback(true).defaultSupplier(() -> false).build()).build();
    public static final FieldReference<Boolean> enableAnimator = FieldReference.builder(value -> {
        TrimicaToggles.enableAnimator = value;
    }, () -> TrimicaToggles.enableAnimator, (GenericType)new GenericType(Boolean.class, new GenericType[0]), (String)"enable_animator").doesSync(true).comment("Whether the animator item should be enabled.\n Disabling this will prevent the animator item from being added to the game\n and any functionality related to it will be disabled.").validator(ValidatorReference.builder().messageProvider(ignored -> "Value for 'enable_animator' is invalid. Resetting to default value: 'true'").fallback(true).defaultSupplier(() -> true).build()).build();
    public static final FieldReference<Boolean> enableItems = FieldReference.builder(value -> {
        TrimicaToggles.enableItems = value;
    }, () -> TrimicaToggles.enableItems, (GenericType)new GenericType(Boolean.class, new GenericType[0]), (String)"enable_items").doesSync(true).comment("Whether the items Trimica adds should be enabled.\n Disabling this will allow you to join servers that don't have Trimica installed").validator(ValidatorReference.builder().messageProvider(ignored -> "Value for 'enable_items' is invalid. Resetting to default value: 'true'").fallback(true).defaultSupplier(() -> true).build()).build();
    public static final FieldReference<Boolean> enableMaterialAdditions = FieldReference.builder(value -> {
        MaterialAdditions.enableMaterialAdditions = value;
    }, () -> MaterialAdditions.enableMaterialAdditions, (GenericType)new GenericType(Boolean.class, new GenericType[0]), (String)"enable_material_additions").doesSync(true).comment("Whether material additions are enabled.\n Disabling this will prevent any material additions from being applied\n and will prevent any recipes that use material additions from working.").onSet(Trimica::refreshEverything).validator(ValidatorReference.builder().messageProvider(ignored -> "Value for 'enable_material_additions' is invalid. Resetting to default value: 'true'").fallback(true).defaultSupplier(() -> true).build()).build();
    public static final FieldReference<Boolean> enablePerPatternItemTextures = FieldReference.builder(value -> {
        Trimica.enablePerPatternItemTextures = value;
    }, () -> Trimica.enablePerPatternItemTextures, (GenericType)new GenericType(Boolean.class, new GenericType[0]), (String)"enable_per_pattern_item_textures").doesSync(true).comment("Whether to enable per-pattern item textures.\n Disabling this will cause all item textures to use the default trim texture for their armour type regardless of the pattern.\n or the type of item (This will cause elytra trims to use the chestplate texture).").onSet(Trimica::refreshEverything).validator(ValidatorReference.builder().messageProvider(ignored -> "Value for 'enable_per_pattern_item_textures' is invalid. Resetting to default value: 'true'").fallback(true).defaultSupplier(() -> true).build()).build();
    public static final FieldReference<Boolean> enableRainbowifier = FieldReference.builder(value -> {
        TrimicaToggles.enableRainbowifier = value;
    }, () -> TrimicaToggles.enableRainbowifier, (GenericType)new GenericType(Boolean.class, new GenericType[0]), (String)"enable_rainbowifier").doesSync(true).comment("Whether the rainbowifier item should be enabled.\n Disabling this will prevent the rainbowifier trim material from being added to the game").validator(ValidatorReference.builder().messageProvider(ignored -> "Value for 'enable_rainbowifier' is invalid. Resetting to default value: 'true'").fallback(true).defaultSupplier(() -> true).build()).build();
    public static final FieldReference<Boolean> enableTrimEverything = FieldReference.builder(value -> {
        TrimMaterialRuntimeRegistry.enableTrimEverything = value;
    }, () -> TrimMaterialRuntimeRegistry.enableTrimEverything, (GenericType)new GenericType(Boolean.class, new GenericType[0]), (String)"enable_trim_everything").doesSync(true).comment("Whether you can trim anything with anything.\n Disabling this will prevent non-builtin materials from being used for trimming\n and prevent any armour that doesn't support trimming from being trimmed").onSet(Trimica::refreshEverything).validator(ValidatorReference.builder().messageProvider(ignored -> "Value for 'enable_trim_everything' is invalid. Resetting to default value: 'true'").fallback(true).defaultSupplier(() -> true).build()).build();

    public String getName() {
        return "trimica";
    }

    public FileType getFileType() {
        return FileType.JSON;
    }

    public void load(SaveLoader saveLoader) {
        saveLoader.load(this.getFields());
    }

    public void save(SaveLoader saveLoader) {
        saveLoader.save(this.getFields());
    }

    public List<FieldReference<?>> getFields() {
        ArrayList fields = new ArrayList();
        fields.add(enableAdditionalTrims);
        fields.add(enableAnimator);
        fields.add(enableItems);
        fields.add(enableMaterialAdditions);
        fields.add(enablePerPatternItemTextures);
        fields.add(enableRainbowifier);
        fields.add(enableTrimEverything);
        fields.sort(Comparator.comparing(ref -> "%s.%s".formatted(ref.group(), ref.name())));
        return fields;
    }
}

