/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.api.client.impl;

import com.bawnorton.trimica.api.BaseTextureInterceptor;
import com.bawnorton.trimica.api.PaletteInterceptor;
import com.bawnorton.trimica.api.client.TrimicaClientApi;
import com.bawnorton.trimica.api.client.TrimicaRenderer;
import com.bawnorton.trimica.api.client.impl.TrimicaRendererImpl;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.util.SortableEndpointHolder;
import java.util.PriorityQueue;
import java.util.Queue;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_9473;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class TrimicaClientApiImpl
implements TrimicaClientApi {
    public static final TrimicaClientApiImpl INSTANCE = new TrimicaClientApiImpl();
    private final TrimicaRenderer renderer = new TrimicaRendererImpl();
    private final Queue<SortableEndpointHolder<BaseTextureInterceptor>> baseTextureInterceptors = new PriorityQueue<SortableEndpointHolder<BaseTextureInterceptor>>();
    private final Queue<SortableEndpointHolder<PaletteInterceptor>> paletteInterceptors = new PriorityQueue<SortableEndpointHolder<PaletteInterceptor>>();

    @Override
    public TrimicaRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void registerBaseTextureInterceptor(int priority, BaseTextureInterceptor baseTextureInterceptor) {
        this.baseTextureInterceptors.add(new SortableEndpointHolder<BaseTextureInterceptor>(baseTextureInterceptor, priority));
    }

    @Override
    public void registerPaletteInterceptor(int priority, PaletteInterceptor paletteInterceptor) {
        this.paletteInterceptors.add(new SortableEndpointHolder<PaletteInterceptor>(paletteInterceptor, priority));
    }

    public class_2960 applyBaseTextureInterceptorsForItem(class_2960 expectedBaseTexture, class_1799 itemWithTrim, class_8053 armourTrim) {
        for (SortableEndpointHolder sortableEndpointHolder : this.baseTextureInterceptors) {
            expectedBaseTexture = ((BaseTextureInterceptor)sortableEndpointHolder.endpoint()).interceptItemTexture(expectedBaseTexture, itemWithTrim, armourTrim);
        }
        return expectedBaseTexture;
    }

    public class_2960 applyBaseTextureInterceptorsForArmour(class_2960 expectedBaseTexture, class_1799 itemWithTrim, class_8053 armourTrim) {
        for (SortableEndpointHolder sortableEndpointHolder : this.baseTextureInterceptors) {
            expectedBaseTexture = ((BaseTextureInterceptor)sortableEndpointHolder.endpoint()).interceptArmourTexture(expectedBaseTexture, itemWithTrim, armourTrim);
        }
        return expectedBaseTexture;
    }

    public class_2960 applyBaseTextureInterceptorsForShield(class_2960 expectedBaseTexture, class_9473 componentGetter, class_8053 armourTrim) {
        for (SortableEndpointHolder sortableEndpointHolder : this.baseTextureInterceptors) {
            expectedBaseTexture = ((BaseTextureInterceptor)sortableEndpointHolder.endpoint()).interceptShieldTexture(expectedBaseTexture, componentGetter, armourTrim);
        }
        return expectedBaseTexture;
    }

    public TrimPalette applyPaletteInterceptorsForGeneration(TrimPalette generated, class_8054 material, MaterialAdditions materialAdditions) {
        for (SortableEndpointHolder sortableEndpointHolder : this.paletteInterceptors) {
            generated = ((PaletteInterceptor)sortableEndpointHolder.endpoint()).interceptPaletteGeneration(generated, material, materialAdditions);
        }
        return generated;
    }
}

