/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.model;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.mixin.accessor.BlockModelWrapperAccessor;
import com.bawnorton.trimica.client.mixin.accessor.GameRendererAccessor;
import com.bawnorton.trimica.client.mixin.accessor.GuiRendererAccessor;
import com.bawnorton.trimica.client.mixin.accessor.ModelBakery$ModelBakerImplAccessor;
import com.bawnorton.trimica.client.mixin.accessor.ModelDiscover$ModelWrapperAccessor;
import com.bawnorton.trimica.client.mixin.accessor.ModelManagerAccessor;
import com.bawnorton.trimica.client.mixin.accessor.TextureSlots$ValueAccessor;
import com.bawnorton.trimica.client.model.TrimModelId;
import com.bawnorton.trimica.client.model.TrimmedItemModelWrapper;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.trim.TrimmedType;
import com.google.common.collect.ImmutableMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_10096;
import net.minecraft.class_10097;
import net.minecraft.class_10192;
import net.minecraft.class_10394;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10813;
import net.minecraft.class_10819;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_1100;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4730;
import net.minecraft.class_5321;
import net.minecraft.class_5599;
import net.minecraft.class_638;
import net.minecraft.class_7775;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import net.minecraft.class_9826;
import org.jetbrains.annotations.NotNull;

public final class TrimItemModelFactory {
    private final Map<class_2960, class_10439> modelCache = new HashMap<class_2960, class_10439>();
    private final Map<class_2960, TrimPalette> paletteCache = new HashMap<class_2960, TrimPalette>();
    private final Map<class_10439, class_2960> baseModelLocations = new HashMap<class_10439, class_2960>();
    private class_1092.class_10816 resolvedModels;

    public TrimmedItemModelWrapper getOrCreateModel(class_10439 base, class_638 level, class_1799 stack, class_8053 trim) {
        class_2960 baseModelLocation;
        class_2960 newModelLocation;
        TrimModelId trimModelId = TrimItemModelFactory.getModelId(stack, trim);
        if (trimModelId == null) {
            return TrimmedItemModelWrapper.noTrim(base);
        }
        class_2960 overlayLocation = trimModelId.asSingle();
        if (MaterialAdditions.enableMaterialAdditions) {
            MaterialAdditions addition = (MaterialAdditions)stack.method_58695(MaterialAdditions.TYPE, (Object)MaterialAdditions.NONE);
            overlayLocation = addition.apply(overlayLocation);
        }
        if (this.modelCache.containsKey(newModelLocation = overlayLocation.method_45138((baseModelLocation = this.baseModelLocations.computeIfAbsent(base, k -> ((class_2960)stack.method_58695(class_9334.field_54199, (Object)class_7923.field_41178.method_10221((Object)stack.method_7909()))).method_45138("item/"))).toString().replace(":", "_") + "/"))) {
            return new TrimmedItemModelWrapper(this.modelCache.get(newModelLocation), this.paletteCache.get(newModelLocation), newModelLocation);
        }
        class_10439 model = this.createModel(baseModelLocation, newModelLocation, overlayLocation, base, level, stack, trim);
        this.modelCache.put(newModelLocation, model);
        return new TrimmedItemModelWrapper(model, this.paletteCache.get(newModelLocation), newModelLocation);
    }

    public static TrimModelId getModelId(class_1799 stack, class_8053 trim) {
        Optional assetId = Optional.ofNullable((class_10192)stack.method_58694(class_9334.field_54196)).flatMap(class_10192::comp_3176);
        TrimmedType trimmedType = TrimmedType.of(stack);
        if (trimmedType == TrimmedType.UNKNOWN) {
            return null;
        }
        return TrimModelId.fromTrim(trimmedType, trim, (class_5321<class_10394>)((class_5321)assetId.orElse(null)));
    }

    private class_10439 createModel(class_2960 baseModelLocation, class_2960 newModelLocation, final class_2960 overlayLocation, class_10439 base, class_638 level, class_1799 stack, class_8053 trim) {
        class_10819 baseResolved = (class_10819)this.resolvedModels.comp_3775().get(baseModelLocation);
        if (baseResolved == null) {
            Trimica.LOGGER.error("Failed to find base resolved model: {}", (Object)baseModelLocation);
            return base;
        }
        class_10419.class_10420 slots = baseResolved.method_68031().comp_3743();
        Map baseContents = slots.comp_3376();
        String targetLayer = this.findTargetLayer(baseContents);
        ImmutableMap contents = ImmutableMap.builder().putAll(slots.comp_3376()).put((Object)targetLayer, (Object)TextureSlots$ValueAccessor.trimica$init(new class_4730(overlayLocation, overlayLocation))).buildKeepingLast();
        class_793 generatedModel = new class_793(null, class_1100.class_4751.field_21858, Boolean.valueOf(false), null, new class_10419.class_10420((Map)contents), class_2960.method_60656((String)"item/generated"));
        class_10097.class_10814 resolvedModel = ModelDiscover$ModelWrapperAccessor.trimica$init(newModelLocation, (class_1100)generatedModel, true);
        ((ModelDiscover$ModelWrapperAccessor)resolvedModel).trimica$parent((class_10097.class_10814)baseResolved.method_68038());
        class_310 minecraft = class_310.method_1551();
        final class_1092 modelManager = minecraft.method_1554();
        class_1088 modelBakery = new class_1088(class_5599.field_55267, Map.of(), Map.of(), Map.of(newModelLocation, resolvedModel), (class_10819)ModelDiscover$ModelWrapperAccessor.trimica$init(class_10096.field_53660, class_10096.method_62629(), true));
        final DynamicTrimTextureAtlasSprite sprite = TrimicaClient.getRuntimeAtlases().getItemAtlas(level, (class_8054)trim.comp_3179().comp_349()).getSprite((class_9473)stack, (class_8056)trim.comp_3180().comp_349(), overlayLocation);
        this.paletteCache.put(newModelLocation, sprite.getPalette());
        class_9826 spriteGetter = new class_9826(){

            @NotNull
            public class_1058 method_65739(class_4730 material, @NotNull class_10813 modelDebugName) {
                if (material.method_24147().equals((Object)overlayLocation)) {
                    return sprite;
                }
                class_1059 atlas = modelManager.method_24153(material.method_24144());
                return atlas.method_4608(material.method_24147());
            }

            @NotNull
            public class_1058 method_65740(@NotNull String string, @NotNull class_10813 modelDebugName) {
                throw new IllegalStateException("Dynamic sprite missing: \"%s\" in model: \"%s\"".formatted(string, modelDebugName.debugName()));
            }
        };
        class_1088.class_10812 missingModels = ((ModelManagerAccessor)modelManager).trimica$missingModels();
        class_10439.class_10440 bakingContext = new class_10439.class_10440((class_7775)ModelBakery$ModelBakerImplAccessor.trimic$init(modelBakery, spriteGetter), class_5599.field_55267, missingModels.comp_3772(), null);
        class_10430.class_10431 unbaked = new class_10430.class_10431(newModelLocation, ((BlockModelWrapperAccessor)base).trimica$tints());
        return unbaked.method_65587(bakingContext);
    }

    private String findTargetLayer(Map<String, class_10419.class_10424> baseContents) {
        String targetLayer;
        int trimLayerIndex = -1;
        for (Map.Entry<String, class_10419.class_10424> entry : baseContents.entrySet()) {
            String texture;
            class_10419.class_10424 class_104242;
            String key2 = entry.getKey();
            class_10419.class_10424 content = entry.getValue();
            if (!key2.startsWith("layer")) continue;
            Objects.requireNonNull(content);
            int n = 0;
            if (!(texture = (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_10419.class_10425.class, class_10419.class_10422.class}, (Object)class_104242, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    class_10419.class_10425 value = (class_10419.class_10425)class_104242;
                    yield value.comp_3378().method_24147().method_12832();
                }
                case 1 -> {
                    class_10419.class_10422 reference = (class_10419.class_10422)class_104242;
                    yield reference.comp_3377();
                }
            })).startsWith("trims/")) continue;
            trimLayerIndex = Integer.parseInt(key2.substring("layer".length()));
            break;
        }
        if (trimLayerIndex != -1) {
            targetLayer = "layer" + trimLayerIndex;
        } else {
            String largestLayer = baseContents.keySet().stream().filter(key -> key.startsWith("layer")).max(Comparator.comparingInt(a -> Integer.parseInt(a.substring("layer".length())))).orElse("layer0");
            int largestIndex = Integer.parseInt(largestLayer.substring("layer".length()));
            targetLayer = "layer" + (largestIndex + 1);
        }
        return targetLayer;
    }

    public void setResolvedModels(class_1092.class_10816 resolvedModels) {
        this.resolvedModels = resolvedModels;
    }

    public void registerBakedModel(class_10439 original, class_2960 model) {
        this.baseModelLocations.put(original, model);
    }

    public void clearModels() {
        this.modelCache.clear();
    }

    public void clear() {
        this.clearModels();
        ((GuiRendererAccessor)((GameRendererAccessor)class_310.method_1551().field_1773).trimica$guiRenderer()).trimica$invalidateItemAtlas();
        this.paletteCache.clear();
    }
}

