/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.client.mixin.accessor.SpriteContents$TickerAccessor;
import com.bawnorton.trimica.client.mixin.accessor.TextureAtlasAccessor;
import com.bawnorton.trimica.client.mixin.accessor.TextureAtlasSprite$TickerAccessor;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.AbstractTrimSpriteFactory;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlases;
import com.bawnorton.trimica.client.texture.TrimSpriteContents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4724;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import net.minecraft.class_7768;
import net.minecraft.class_8056;
import net.minecraft.class_9473;
import org.jetbrains.annotations.NotNull;

public final class RuntimeTrimAtlas
extends class_1059 {
    private final AbstractTrimSpriteFactory spriteFactory;
    private final RuntimeTrimAtlases.TrimFactory trimFactory;
    private final class_1921 renderType;
    private final List<class_7764> dynamicSprites = new ArrayList<class_7764>();
    private final Map<class_2960, TrimPalette> palettes = new HashMap<class_2960, TrimPalette>();
    private final Consumer<RuntimeTrimAtlas> onModified;

    public RuntimeTrimAtlas(class_2960 atlasLocation, AbstractTrimSpriteFactory spriteFactory, RuntimeTrimAtlases.TrimFactory trimFactory, Consumer<RuntimeTrimAtlas> onModified) {
        super(atlasLocation);
        this.spriteFactory = spriteFactory;
        this.trimFactory = trimFactory;
        this.renderType = class_1921.method_25448((class_2960)atlasLocation);
        this.dynamicSprites.add(this.createMissing());
        this.onModified = onModified;
    }

    private class_7764 createMissing() {
        class_2960 missingLocation = class_1047.method_4539();
        return this.spriteFactory.create(missingLocation, null, null).spriteContents();
    }

    @NotNull
    public class_1058 method_4608(@NotNull class_2960 texture) {
        throw new UnsupportedOperationException("Use getSprite(DataComponentGetter, TrimMaterial, ResourceLocation) instead");
    }

    @NotNull
    public DynamicTrimTextureAtlasSprite getSprite(class_9473 componentGetter, class_8056 pattern, class_2960 texture) {
        Trimica.LOGGER.info("Getting sprite for {}", (Object)texture);
        Map<class_2960, class_1058> texturesByName = this.asAccessor().trimica$texturesByName();
        class_1058 sprite = texturesByName.get(texture);
        if (sprite == null) {
            sprite = this.createSprite(componentGetter, pattern, texture);
        }
        float width = sprite.method_4577() - sprite.method_4594();
        float height = sprite.method_4575() - sprite.method_4593();
        Trimica.LOGGER.info("Sprite Dimensions: {}wx{}h", (Object)Float.valueOf(width * (float)this.asAccessor().trimica$width()), (Object)Float.valueOf(height * (float)this.asAccessor().trimica$height()));
        Trimica.LOGGER.info("Sprite UV: x={}, y={}", (Object)Float.valueOf(sprite.method_4594() * (float)this.asAccessor().trimica$width()), (Object)Float.valueOf(sprite.method_4593() * (float)this.asAccessor().trimica$height()));
        return new DynamicTrimTextureAtlasSprite(sprite, this.renderType, this.palettes.get(texture));
    }

    private DynamicTrimTextureAtlasSprite createSprite(class_9473 componentGetter, class_8056 pattern, class_2960 texture) {
        TrimSpriteContents sprite = this.spriteFactory.create(texture, this.trimFactory.create(pattern), componentGetter);
        this.dynamicSprites.add(sprite.spriteContents());
        this.stitchAndUpload();
        this.onModified.accept(this);
        class_310 client = class_310.method_1551();
        client.method_1531().method_4616(this.method_24106(), (class_1044)this);
        this.palettes.put(texture, sprite.palette());
        return new DynamicTrimTextureAtlasSprite(this.asAccessor().trimica$texturesByName().get(texture), this.renderType, sprite.palette());
    }

    private void stitchAndUpload() {
        class_7766 loader = class_7766.method_45837((class_1059)this);
        class_7766.class_7767 preparations = loader.method_47663(this.dynamicSprites, 0, (Executor)class_156.method_18349());
        class_4724.class_7774 result = new class_4724.class_7774((class_1059)this, preparations);
        result.method_45871();
    }

    public void method_4601() {
        TextureAtlasAccessor accessor = this.asAccessor();
        accessor.trimica$sprites(List.of());
        accessor.trimica$animatedTextures(List.of());
        accessor.trimica$texturesByName(Map.of());
        accessor.trimica$missingSprite(null);
    }

    public void resetFrames() {
        List<class_1058.class_7770> tickers = this.asAccessor().trimica$animatedTextures();
        for (class_1058.class_7770 ticker : tickers) {
            TextureAtlasSprite$TickerAccessor accessor;
            class_7768 class_77682;
            if (!(ticker instanceof TextureAtlasSprite$TickerAccessor) || !((class_77682 = (accessor = (TextureAtlasSprite$TickerAccessor)ticker).trimica$ticker()) instanceof SpriteContents$TickerAccessor)) continue;
            SpriteContents$TickerAccessor spriteTicker = (SpriteContents$TickerAccessor)class_77682;
            spriteTicker.trimica$frame(0);
        }
    }

    private TextureAtlasAccessor asAccessor() {
        return (TextureAtlasAccessor)((Object)this);
    }

    public void clear() {
        this.spriteFactory.clear();
        this.dynamicSprites.clear();
        this.dynamicSprites.add(this.createMissing());
        this.method_4601();
    }
}

