/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.mixin.render;

import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.mixin.accessor.EquipmentLayerRenderer$TrimSpriteKeyAccessor;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlas;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlases;
import com.bawnorton.trimica.client.texture.TrimArmourSpriteFactory;
import com.bawnorton.trimica.compat.Compat;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EquipmentLayerRenderer.class})
public abstract class EquipmentLayerRendererMixin {
    @Shadow
    @Final
    private Function<EquipmentLayerRenderer.TrimSpriteKey, TextureAtlasSprite> trimSpriteLookup;

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/Util;memoize(Ljava/util/function/Function;)Ljava/util/function/Function;", ordinal=1)})
    private Function<EquipmentLayerRenderer.TrimSpriteKey, TextureAtlasSprite> provideRuntimeTextures(Function<EquipmentLayerRenderer.TrimSpriteKey, TextureAtlasSprite> textureGetter, Operation<Function<EquipmentLayerRenderer.TrimSpriteKey, TextureAtlasSprite>> original) {
        return EquipmentLayerRendererMixin.trimica$dynamicProvider((Function)original.call(new Object[]{textureGetter}));
    }

    @Unique
    @NotNull
    private static Function<EquipmentLayerRenderer.TrimSpriteKey, TextureAtlasSprite> trimica$dynamicProvider(Function<EquipmentLayerRenderer.TrimSpriteKey, TextureAtlasSprite> textureGetter) {
        return trimSpriteKey -> {
            TrimMaterial material;
            TextureAtlasSprite sprite = (TextureAtlasSprite)textureGetter.apply((EquipmentLayerRenderer.TrimSpriteKey)trimSpriteKey);
            ProfilerFiller profiler = Profiler.get();
            profiler.push("trimica:armour_runtime_atlas");
            ItemStack stack = TrimArmourSpriteFactory.ITEM_WITH_TRIM_CAPTURE.get();
            MaterialAdditions addition = (MaterialAdditions)stack.getOrDefault(MaterialAdditions.TYPE, (Object)MaterialAdditions.NONE);
            if (!sprite.contents().name().equals((Object)MissingTextureAtlasSprite.getLocation()) && addition.isEmpty()) {
                return sprite;
            }
            RuntimeTrimAtlases atlases = TrimicaClient.getRuntimeAtlases();
            RuntimeTrimAtlas atlas = atlases.getEquipmentAtlas(Minecraft.getInstance().level, material = (TrimMaterial)trimSpriteKey.trim().material().value(), trimSpriteKey.layerType());
            if (atlas == null) {
                return sprite;
            }
            ResourceLocation overlayLocation = trimSpriteKey.spriteId();
            overlayLocation = addition.apply(overlayLocation);
            TrimPattern pattern = (TrimPattern)trimSpriteKey.trim().pattern().value();
            DynamicTrimTextureAtlasSprite dynamicSprite = atlas.getSprite((DataComponentGetter)stack, pattern, overlayLocation);
            profiler.pop();
            return dynamicSprite;
        };
    }

    @ModifyReceiver(method={"renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;")})
    private ItemStack captureItemWithTrimOrRenderAll(ItemStack instance, DataComponentType<?> dataComponentType, @Local(argsOnly=true) EquipmentClientInfo.LayerType layerType, @Local(argsOnly=true) ResourceKey<EquipmentAsset> equipmentAsset, @Local(argsOnly=true) Model armorModel, @Local(argsOnly=true) PoseStack poseStack, @Local(argsOnly=true) MultiBufferSource bufferSource, @Local(argsOnly=true) int packedLight, @Cancellable CallbackInfo ci) {
        TrimArmourSpriteFactory.ITEM_WITH_TRIM_CAPTURE.set(instance);
        if (!AdditionalTrims.enableAdditionalTrims) {
            return instance;
        }
        ci.cancel();
        ArrayList<BiConsumer<Boolean, Boolean>> renderers = new ArrayList<BiConsumer<Boolean, Boolean>>();
        boolean isEmissive = false;
        boolean isAnimated = false;
        List<ArmorTrim> trims = AdditionalTrims.getAllTrims((DataComponentGetter)instance);
        for (ArmorTrim armorTrim : trims) {
            RenderType renderType;
            TextureAtlasSprite sprite = this.trimSpriteLookup.apply(EquipmentLayerRenderer$TrimSpriteKeyAccessor.trimica$init(armorTrim, layerType, equipmentAsset));
            if (sprite instanceof DynamicTrimTextureAtlasSprite) {
                DynamicTrimTextureAtlasSprite dynamicSprite = (DynamicTrimTextureAtlasSprite)sprite;
                TrimPalette palette = dynamicSprite.getPalette();
                if (palette != null) {
                    if (palette.isAnimated()) {
                        isAnimated = true;
                    }
                    if (palette.isEmissive()) {
                        isEmissive = true;
                    }
                }
                renderType = dynamicSprite.getRenderType();
            } else {
                renderType = Sheets.armorTrimsSheet((boolean)((TrimPattern)armorTrim.pattern().value()).decal());
            }
            renderers.add((emissive, animated) -> {
                if (animated.booleanValue()) {
                    Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(sprite));
                }
                VertexConsumer vertexConsumer = sprite.wrap(bufferSource.getBuffer(renderType));
                armorModel.renderToBuffer(poseStack, vertexConsumer, emissive != false ? 0xF000F0 : packedLight, OverlayTexture.NO_OVERLAY);
            });
        }
        for (BiConsumer biConsumer : renderers) {
            biConsumer.accept(isEmissive, isAnimated);
        }
        return instance;
    }

    @WrapOperation(method={"renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource;getBuffer(Lnet/minecraft/client/renderer/RenderType;)Lcom/mojang/blaze3d/vertex/VertexConsumer;")})
    private VertexConsumer useDynamicRenderType(MultiBufferSource instance, RenderType renderType, Operation<VertexConsumer> original, @Local TextureAtlasSprite textureAtlasSprite, @Share(value="palette") LocalRef<TrimPalette> paletteLocalRef) {
        if (textureAtlasSprite instanceof DynamicTrimTextureAtlasSprite) {
            DynamicTrimTextureAtlasSprite dynamicSprite = (DynamicTrimTextureAtlasSprite)textureAtlasSprite;
            TrimPalette palette = dynamicSprite.getPalette();
            paletteLocalRef.set((Object)palette);
            if (palette != null && palette.isAnimated()) {
                Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(dynamicSprite));
            }
            return (VertexConsumer)original.call(new Object[]{instance, dynamicSprite.getRenderType()});
        }
        return (VertexConsumer)original.call(new Object[]{instance, renderType});
    }

    @WrapOperation(method={"renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/Model;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V")})
    private void usePaletteLightness(Model instance, PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, Operation<Void> original, @Share(value="palette") LocalRef<TrimPalette> paletteLocalRef) {
        TrimPalette palette = (TrimPalette)paletteLocalRef.get();
        int light = palette == null ? i : (palette.isEmissive() ? 0xF000F0 : i);
        original.call(new Object[]{instance, poseStack, vertexConsumer, light, j});
    }
}

