/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.mixin.render;

import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.compat.Compat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.special.ShieldSpecialRenderer;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemDisplayContext;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShieldSpecialRenderer.class})
public abstract class ShieldSpecialRendererMixin {
    @Shadow
    @Final
    private ShieldModel model;

    @Inject(method={"render(Lnet/minecraft/core/component/DataComponentMap;Lnet/minecraft/world/item/ItemDisplayContext;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IIZ)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V")})
    private void renderTrim(DataComponentMap dataComponentMap, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, boolean bl, CallbackInfo ci) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("trimica:shield");
        List<DynamicTrimTextureAtlasSprite> dynamicSprites = TrimicaClient.getRuntimeAtlases().getShieldSprites(Minecraft.getInstance().level, (DataComponentGetter)dataComponentMap);
        for (DynamicTrimTextureAtlasSprite dynamicSprite : dynamicSprites) {
            int light;
            TrimPalette palette = dynamicSprite.getPalette();
            int n = palette == null ? i : (light = palette.isEmissive() ? 0xF000F0 : i);
            if (palette != null && palette.isAnimated()) {
                Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(dynamicSprite));
            }
            VertexConsumer vertexConsumer = dynamicSprite.wrap(ItemRenderer.getFoilBuffer((MultiBufferSource)multiBufferSource, (RenderType)dynamicSprite.getRenderType(), (itemDisplayContext == ItemDisplayContext.GUI ? 1 : 0) != 0, (boolean)bl));
            this.model.plate().render(poseStack, vertexConsumer, light, j);
        }
        profiler.pop();
    }
}

