/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.model;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.mixin.accessor.BlockModelWrapperAccessor;
import com.bawnorton.trimica.client.mixin.accessor.GameRendererAccessor;
import com.bawnorton.trimica.client.mixin.accessor.GuiRendererAccessor;
import com.bawnorton.trimica.client.mixin.accessor.ModelBakery$ModelBakerImplAccessor;
import com.bawnorton.trimica.client.mixin.accessor.ModelDiscover$ModelWrapperAccessor;
import com.bawnorton.trimica.client.mixin.accessor.ModelManagerAccessor;
import com.bawnorton.trimica.client.mixin.accessor.TextureSlots$ValueAccessor;
import com.bawnorton.trimica.client.model.TrimModelId;
import com.bawnorton.trimica.client.model.TrimmedItemModelWrapper;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.trim.TrimmedType;
import com.google.common.collect.ImmutableMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelDiscovery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.jetbrains.annotations.NotNull;

public final class TrimItemModelFactory {
    private final Map<ResourceLocation, ItemModel> modelCache = new HashMap<ResourceLocation, ItemModel>();
    private final Map<ResourceLocation, TrimPalette> paletteCache = new HashMap<ResourceLocation, TrimPalette>();
    private final Map<ItemModel, ResourceLocation> baseModelLocations = new HashMap<ItemModel, ResourceLocation>();
    private ModelManager.ResolvedModels resolvedModels;

    public TrimmedItemModelWrapper getOrCreateModel(ItemModel base, ClientLevel level, ItemStack stack, ArmorTrim trim) {
        ResourceLocation baseModelLocation;
        ResourceLocation newModelLocation;
        TrimModelId trimModelId = TrimItemModelFactory.getModelId(stack, trim);
        if (trimModelId == null) {
            return TrimmedItemModelWrapper.noTrim(base);
        }
        ResourceLocation overlayLocation = trimModelId.asSingle();
        if (MaterialAdditions.enableMaterialAdditions) {
            MaterialAdditions addition = (MaterialAdditions)stack.getOrDefault(MaterialAdditions.TYPE, (Object)MaterialAdditions.NONE);
            overlayLocation = addition.apply(overlayLocation);
        }
        if (this.modelCache.containsKey(newModelLocation = overlayLocation.withPrefix((baseModelLocation = this.baseModelLocations.computeIfAbsent(base, k -> ((ResourceLocation)stack.getOrDefault(DataComponents.ITEM_MODEL, (Object)BuiltInRegistries.ITEM.getKey((Object)stack.getItem()))).withPrefix("item/"))).toString().replace(":", "_") + "/"))) {
            return new TrimmedItemModelWrapper(this.modelCache.get(newModelLocation), this.paletteCache.get(newModelLocation), newModelLocation);
        }
        ItemModel model = this.createModel(baseModelLocation, newModelLocation, overlayLocation, base, level, stack, trim);
        this.modelCache.put(newModelLocation, model);
        return new TrimmedItemModelWrapper(model, this.paletteCache.get(newModelLocation), newModelLocation);
    }

    public static TrimModelId getModelId(ItemStack stack, ArmorTrim trim) {
        Optional assetId = Optional.ofNullable((Equippable)stack.get(DataComponents.EQUIPPABLE)).flatMap(Equippable::assetId);
        TrimmedType trimmedType = TrimmedType.of(stack);
        if (trimmedType == TrimmedType.UNKNOWN) {
            return null;
        }
        return TrimModelId.fromTrim(trimmedType, trim, (ResourceKey<EquipmentAsset>)((ResourceKey)assetId.orElse(null)));
    }

    private ItemModel createModel(ResourceLocation baseModelLocation, ResourceLocation newModelLocation, final ResourceLocation overlayLocation, ItemModel base, ClientLevel level, ItemStack stack, ArmorTrim trim) {
        ResolvedModel baseResolved = (ResolvedModel)this.resolvedModels.models().get(baseModelLocation);
        if (baseResolved == null) {
            Trimica.LOGGER.error("Failed to find base resolved model: {}", (Object)baseModelLocation);
            return base;
        }
        TextureSlots.Data slots = baseResolved.wrapped().textureSlots();
        Map baseContents = slots.values();
        String targetLayer = this.findTargetLayer(baseContents);
        ImmutableMap contents = ImmutableMap.builder().putAll(slots.values()).put((Object)targetLayer, (Object)TextureSlots$ValueAccessor.trimica$init(new Material(overlayLocation, overlayLocation))).buildKeepingLast();
        BlockModel generatedModel = new BlockModel(null, UnbakedModel.GuiLight.FRONT, Boolean.valueOf(false), null, new TextureSlots.Data((Map)contents), ResourceLocation.withDefaultNamespace((String)"item/generated"));
        ModelDiscovery.ModelWrapper resolvedModel = ModelDiscover$ModelWrapperAccessor.trimica$init(newModelLocation, (UnbakedModel)generatedModel, true);
        ((ModelDiscover$ModelWrapperAccessor)resolvedModel).trimica$parent((ModelDiscovery.ModelWrapper)baseResolved.parent());
        Minecraft minecraft = Minecraft.getInstance();
        final ModelManager modelManager = minecraft.getModelManager();
        ModelBakery modelBakery = new ModelBakery(EntityModelSet.EMPTY, Map.of(), Map.of(), Map.of(newModelLocation, resolvedModel), (ResolvedModel)ModelDiscover$ModelWrapperAccessor.trimica$init(MissingBlockModel.LOCATION, MissingBlockModel.missingModel(), true));
        final DynamicTrimTextureAtlasSprite sprite = TrimicaClient.getRuntimeAtlases().getItemAtlas(level, (TrimMaterial)trim.material().value()).getSprite((DataComponentGetter)stack, (TrimPattern)trim.pattern().value(), overlayLocation);
        this.paletteCache.put(newModelLocation, sprite.getPalette());
        SpriteGetter spriteGetter = new SpriteGetter(){

            @NotNull
            public TextureAtlasSprite get(Material material, @NotNull ModelDebugName modelDebugName) {
                if (material.texture().equals((Object)overlayLocation)) {
                    return sprite;
                }
                TextureAtlas atlas = modelManager.getAtlas(material.atlasLocation());
                return atlas.getSprite(material.texture());
            }

            @NotNull
            public TextureAtlasSprite reportMissingReference(@NotNull String string, @NotNull ModelDebugName modelDebugName) {
                throw new IllegalStateException("Dynamic sprite missing: \"%s\" in model: \"%s\"".formatted(string, modelDebugName.debugName()));
            }
        };
        ModelBakery.MissingModels missingModels = ((ModelManagerAccessor)modelManager).trimica$missingModels();
        ItemModel.BakingContext bakingContext = new ItemModel.BakingContext((ModelBaker)ModelBakery$ModelBakerImplAccessor.trimic$init(modelBakery, spriteGetter), EntityModelSet.EMPTY, missingModels.item(), null);
        BlockModelWrapper.Unbaked unbaked = new BlockModelWrapper.Unbaked(newModelLocation, ((BlockModelWrapperAccessor)base).trimica$tints());
        return unbaked.bake(bakingContext);
    }

    private String findTargetLayer(Map<String, TextureSlots.SlotContents> baseContents) {
        String targetLayer;
        int trimLayerIndex = -1;
        for (Map.Entry<String, TextureSlots.SlotContents> entry : baseContents.entrySet()) {
            String texture;
            TextureSlots.SlotContents slotContents;
            String key2 = entry.getKey();
            TextureSlots.SlotContents content = entry.getValue();
            if (!key2.startsWith("layer")) continue;
            Objects.requireNonNull(content);
            int n = 0;
            if (!(texture = (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextureSlots.Value.class, TextureSlots.Reference.class}, (Object)slotContents, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    TextureSlots.Value value = (TextureSlots.Value)slotContents;
                    yield value.material().texture().getPath();
                }
                case 1 -> {
                    TextureSlots.Reference reference = (TextureSlots.Reference)slotContents;
                    yield reference.target();
                }
            })).startsWith("trims/")) continue;
            trimLayerIndex = Integer.parseInt(key2.substring("layer".length()));
            break;
        }
        if (trimLayerIndex != -1) {
            targetLayer = "layer" + trimLayerIndex;
        } else {
            String largestLayer = baseContents.keySet().stream().filter(key -> key.startsWith("layer")).max(Comparator.comparingInt(a -> Integer.parseInt(a.substring("layer".length())))).orElse("layer0");
            int largestIndex = Integer.parseInt(largestLayer.substring("layer".length()));
            targetLayer = "layer" + (largestIndex + 1);
        }
        return targetLayer;
    }

    public void setResolvedModels(ModelManager.ResolvedModels resolvedModels) {
        this.resolvedModels = resolvedModels;
    }

    public void registerBakedModel(ItemModel original, ResourceLocation model) {
        this.baseModelLocations.put(original, model);
    }

    public void clearModels() {
        this.modelCache.clear();
    }

    public void clear() {
        this.clearModels();
        ((GuiRendererAccessor)((GameRendererAccessor)Minecraft.getInstance().gameRenderer).trimica$guiRenderer()).trimica$invalidateItemAtlas();
        this.paletteCache.clear();
    }
}

