/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.palette;

import com.bawnorton.trimica.client.colour.ColourHSB;
import com.bawnorton.trimica.client.palette.AnimatedTrimPalette;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.util.ARGB;

public class TrimPalette {
    public static final TrimPalette DEFAULT = new TrimPalette(ARGB.color((int)255, (int)255, (int)255, (int)255));
    public static final TrimPalette MISSING = new TrimPalette(List.of(Integer.valueOf(ARGB.color((int)255, (int)255, (int)0, (int)255)), Integer.valueOf(ARGB.color((int)255, (int)0, (int)0, (int)0)), Integer.valueOf(ARGB.color((int)255, (int)255, (int)0, (int)255)), Integer.valueOf(ARGB.color((int)255, (int)0, (int)0, (int)0)), Integer.valueOf(ARGB.color((int)255, (int)255, (int)0, (int)255)), Integer.valueOf(ARGB.color((int)255, (int)0, (int)0, (int)0)), Integer.valueOf(ARGB.color((int)255, (int)255, (int)0, (int)255)), Integer.valueOf(ARGB.color((int)255, (int)0, (int)0, (int)0))));
    public static final TrimPalette DISABLED = new TrimPalette(List.of(Integer.valueOf(ARGB.color((int)255, (int)255, (int)0, (int)0)), Integer.valueOf(ARGB.color((int)255, (int)0, (int)0, (int)0)), Integer.valueOf(ARGB.color((int)255, (int)255, (int)0, (int)0)), Integer.valueOf(ARGB.color((int)255, (int)0, (int)0, (int)0)), Integer.valueOf(ARGB.color((int)255, (int)255, (int)0, (int)0)), Integer.valueOf(ARGB.color((int)255, (int)0, (int)0, (int)0)), Integer.valueOf(ARGB.color((int)255, (int)255, (int)0, (int)0)), Integer.valueOf(ARGB.color((int)255, (int)0, (int)0, (int)0))));
    public static final int PALETTE_SIZE = 8;
    private final List<Integer> colours;
    private final boolean builtin;
    private boolean emissive = false;

    public TrimPalette(List<Integer> colours, boolean builtin) {
        if (colours.size() != 8) {
            throw new IllegalArgumentException("Trim palette requires exactly %s colours, but %s were found.".formatted(8, colours.size()));
        }
        this.colours = new ArrayList<Integer>(colours);
        this.builtin = builtin;
    }

    public TrimPalette(List<Integer> colours) {
        this(colours, false);
    }

    public TrimPalette(int singleColour) {
        this((List)Util.make(new ArrayList(), colours -> {
            for (int i = 0; i < 8; ++i) {
                colours.add(singleColour);
            }
        }));
    }

    public TrimPalette asAnimated() {
        AnimatedTrimPalette animatedTrimPalette = new AnimatedTrimPalette(this.colours);
        animatedTrimPalette.setEmissive(this.emissive);
        return animatedTrimPalette;
    }

    public boolean isAnimated() {
        return false;
    }

    public void setEmissive(boolean emissive) {
        this.emissive = emissive;
    }

    public boolean isEmissive() {
        return this.emissive;
    }

    public List<Integer> getColours() {
        return this.colours;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public int getTooltipColour() {
        List<ColourHSB> hsbColours = ColourHSB.fromARGB(this.colours);
        hsbColours.removeIf(colour -> colour.saturation() < 0.25f || colour.brightness() < 0.5f);
        if (hsbColours.isEmpty()) {
            return this.colours.getFirst();
        }
        Collections.sort(hsbColours);
        return hsbColours.getFirst().rgb();
    }

    public String getMetadataString() {
        StringBuilder metadata = new StringBuilder();
        if (this.isBuiltin()) {
            metadata.append("built-in_");
        }
        if (this.isEmissive()) {
            metadata.append("emissive_");
        }
        if (this.isAnimated()) {
            metadata.append("animated_");
        }
        if (metadata.isEmpty()) {
            metadata.append("default_");
        }
        metadata.deleteCharAt(metadata.length() - 1);
        return metadata.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrimPalette) {
            TrimPalette other = (TrimPalette)obj;
            return Objects.equals(this.colours, other.colours);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.colours);
    }
}

