/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.api.impl.TrimicaApiImpl;
import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.AbstractTrimSpriteFactory;
import com.bawnorton.trimica.client.texture.TrimSpriteMetadata;
import com.bawnorton.trimica.trim.TrimmedType;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureContents;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.jetbrains.annotations.Nullable;

public class TrimArmourSpriteFactory
extends AbstractTrimSpriteFactory {
    private final EquipmentClientInfo.LayerType layerType;
    public static final ThreadLocal<ItemStack> ITEM_WITH_TRIM_CAPTURE = ThreadLocal.withInitial(() -> null);

    public TrimArmourSpriteFactory(EquipmentClientInfo.LayerType layerType) {
        super(64, 32);
        this.layerType = layerType;
    }

    @Override
    @Nullable
    protected TrimSpriteMetadata getSpriteMetadata(ArmorTrim trim, DataComponentGetter componentGetter, ResourceLocation texture) {
        if (!(componentGetter instanceof ItemStack)) {
            return null;
        }
        ItemStack stack = (ItemStack)componentGetter;
        TrimmedType trimmedType = TrimmedType.of(stack);
        TrimMaterial material = (TrimMaterial)trim.material().value();
        ResourceKey assetResourceKey = Optional.ofNullable((Equippable)stack.get(DataComponents.EQUIPPABLE)).flatMap(Equippable::assetId).orElse(null);
        TrimPalette palette = TrimicaClient.getPalettes().getOrGeneratePalette(material, (ResourceKey<EquipmentAsset>)assetResourceKey, componentGetter);
        ResourceLocation basePatternTexture = this.extractBaseTexture(texture, ((TrimPattern)trim.pattern().value()).assetId());
        basePatternTexture = TrimicaApiImpl.INSTANCE.applyBaseTextureInterceptorsForArmour(basePatternTexture, stack, trim);
        return new TrimSpriteMetadata(trim, palette, basePatternTexture, trimmedType);
    }

    @Override
    protected NativeImage createImageFromMetadata(TrimSpriteMetadata metadata) {
        Minecraft minecraft = Minecraft.getInstance();
        TextureContents contents = textureCache.computeIfAbsent(metadata.baseTexture(), k -> {
            try {
                return TextureContents.load((ResourceManager)minecraft.getResourceManager(), (ResourceLocation)metadata.baseTexture());
            }
            catch (IOException e) {
                Trimica.LOGGER.warn("Expected to find \"{}\" but the texture does of exist, trim overlay will not be added to model", (Object)metadata.baseTexture());
                return new TextureContents(this.empty(), null);
            }
        });
        return this.createColouredImage(metadata, contents);
    }

    private ResourceLocation extractBaseTexture(ResourceLocation texture, ResourceLocation assetId) {
        return texture.withPath("textures/%s/%s.png".formatted(this.layerType.trimAssetPrefix(), assetId.getPath()));
    }
}

