/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.compat.elytratrims;

import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlas;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlases;
import com.bawnorton.trimica.compat.Compat;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.google.auto.service.AutoService;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.kikugie.elytratrims.api.ETClientInitializer;
import dev.kikugie.elytratrims.api.render.ETRenderParameters;
import dev.kikugie.elytratrims.api.render.ETRendererID;
import dev.kikugie.elytratrims.api.render.ETRenderingAPI;
import dev.kikugie.elytratrims.api.render.ETRenderingAPIUtils;
import dev.kikugie.elytratrims.render.impl.ETTrimsRenderer;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;

@AutoService(value={ETClientInitializer.class})
public class ElytraTrimsClientEntrypoint
implements ETClientInitializer {
    public void onInitializeClientET() {
        ETRenderingAPI.wrapRenderCall((ETRendererID)ETTrimsRenderer.type, this::renderWithTrimica);
    }

    private boolean renderWithTrimica(ETRenderParameters parameters, Function<ETRenderParameters, Boolean> original) {
        Supplier<Boolean> callOriginal = () -> (Boolean)original.apply(parameters);
        ItemStack stack = parameters.stack();
        List<ArmorTrim> trims = AdditionalTrims.getAllTrims((DataComponentGetter)stack);
        if (trims.isEmpty()) {
            return callOriginal.get();
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return callOriginal.get();
        }
        for (ArmorTrim trim : trims) {
            this.renderWithTrimicaInternal(level, stack, trim, parameters, callOriginal::get, (sprite, light) -> {
                VertexConsumer vertexConsumer = sprite.wrap(ItemRenderer.getArmorFoilBuffer((MultiBufferSource)parameters.source(), (RenderType)sprite.getRenderType(), (boolean)stack.hasFoil()));
                Model elytra = parameters.elytra();
                elytra.renderToBuffer(parameters.matrices(), vertexConsumer, light, OverlayTexture.NO_OVERLAY, parameters.color());
            });
        }
        return true;
    }

    private void renderWithTrimicaInternal(ClientLevel level, ItemStack stack, ArmorTrim trim, ETRenderParameters parameters, Runnable original, Renderer renderer) {
        TrimPattern pattern;
        DynamicTrimTextureAtlasSprite newSprite;
        TrimPalette palette;
        TrimMaterial material;
        RuntimeTrimAtlases atlases = TrimicaClient.getRuntimeAtlases();
        RuntimeTrimAtlas atlas = atlases.getEquipmentAtlas(level, material = (TrimMaterial)trim.material().value(), EquipmentClientInfo.LayerType.WINGS);
        if (atlas == null) {
            return;
        }
        ResourceLocation overlayLocation = trim.layerAssetId(EquipmentClientInfo.LayerType.WINGS.trimAssetPrefix(), EquipmentAssets.ELYTRA);
        if (MaterialAdditions.enableMaterialAdditions) {
            MaterialAdditions additions = (MaterialAdditions)stack.getOrDefault(MaterialAdditions.TYPE, (Object)MaterialAdditions.NONE);
            overlayLocation = additions.apply(overlayLocation);
        }
        if ((palette = (newSprite = atlas.getSprite((DataComponentGetter)stack, pattern = (TrimPattern)trim.pattern().value(), overlayLocation)).getPalette()) == null) {
            original.run();
            return;
        }
        if (palette.isAnimated()) {
            Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(newSprite));
        }
        int light = palette.isEmissive() ? 0xF000F0 : ETRenderingAPIUtils.getEffectiveLight((ETRenderParameters)parameters);
    }

    static interface Renderer {
        public void render(DynamicTrimTextureAtlasSprite var1, int var2);
    }
}

