/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.item.crafting;

import com.bawnorton.trimica.api.impl.TrimicaApiImpl;
import com.bawnorton.trimica.data.TrimicaDataGen;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import org.jetbrains.annotations.NotNull;

public class MaterialAdditionRecipe
implements SmithingRecipe {
    public static Serializer SERIALIZER;
    private final Ingredient base;
    private final Ingredient addition;
    private PlacementInfo placementInfo;

    public MaterialAdditionRecipe(Ingredient base, Ingredient addition) {
        this.base = TrimicaDataGen.duringDataGen ? base : TrimicaApiImpl.INSTANCE.applyCraftingRecipeInterceptorsForBase(base);
        this.addition = addition;
    }

    @NotNull
    public ItemStack assemble(@NotNull SmithingRecipeInput recipeInput, @NotNull HolderLookup.Provider provider) {
        return MaterialAdditionRecipe.applyMaterialAddition(recipeInput.base(), recipeInput.addition());
    }

    @NotNull
    public static ItemStack applyMaterialAddition(ItemStack base, ItemStack addition) {
        ResourceLocation additionKey;
        MaterialAdditions newMaterialAdditon;
        if (!MaterialAdditions.enableMaterialAdditions) {
            return ItemStack.EMPTY;
        }
        ArmorTrim existing = (ArmorTrim)base.get(DataComponents.TRIM);
        if (existing == null) {
            return ItemStack.EMPTY;
        }
        MaterialAdditions materialAdditions = (MaterialAdditions)base.getOrDefault(MaterialAdditions.TYPE, (Object)MaterialAdditions.NONE);
        if (materialAdditions.equals(newMaterialAdditon = materialAdditions.and(additionKey = BuiltInRegistries.ITEM.getKey((Object)addition.getItem())))) {
            return ItemStack.EMPTY;
        }
        ItemStack result = base.copyWithCount(1);
        result.set(MaterialAdditions.TYPE, (Object)newMaterialAdditon);
        return result;
    }

    @NotNull
    public RecipeSerializer<? extends SmithingRecipe> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals(List.of(Optional.empty(), Optional.of(this.base), Optional.of(this.addition)));
        }
        return this.placementInfo;
    }

    @NotNull
    public Optional<Ingredient> templateIngredient() {
        return Optional.empty();
    }

    @NotNull
    public Ingredient baseIngredient() {
        return this.base;
    }

    @NotNull
    public Optional<Ingredient> additionIngredient() {
        return Optional.of(this.addition);
    }

    @NotNull
    public List<RecipeDisplay> display() {
        SlotDisplay baseSlot = this.base.display();
        SlotDisplay additionSlot = this.addition.display();
        return List.of(new Display(baseSlot, additionSlot, new DemoSlotDisplay(baseSlot, additionSlot), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.SMITHING_TABLE)));
    }

    private Ingredient getBase() {
        return this.base;
    }

    private Ingredient getAddition() {
        return this.addition;
    }

    public static class Serializer
    implements RecipeSerializer<MaterialAdditionRecipe> {
        private static final MapCodec<MaterialAdditionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("base").forGetter(MaterialAdditionRecipe::getBase), (App)Ingredient.CODEC.fieldOf("addition").forGetter(MaterialAdditionRecipe::getAddition)).apply((Applicative)instance, MaterialAdditionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MaterialAdditionRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, MaterialAdditionRecipe::getBase, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, MaterialAdditionRecipe::getAddition, MaterialAdditionRecipe::new);

        @NotNull
        public MapCodec<MaterialAdditionRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, MaterialAdditionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public record Display(SlotDisplay base, SlotDisplay addition, SlotDisplay result, SlotDisplay craftingStation) implements RecipeDisplay
    {
        public static final MapCodec<Display> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SlotDisplay.CODEC.fieldOf("base").forGetter(Display::base), (App)SlotDisplay.CODEC.fieldOf("addition").forGetter(Display::addition), (App)SlotDisplay.CODEC.fieldOf("result").forGetter(Display::result), (App)SlotDisplay.CODEC.fieldOf("crafting_station").forGetter(Display::craftingStation)).apply((Applicative)instance, Display::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Display> STREAM_CODEC = StreamCodec.composite((StreamCodec)SlotDisplay.STREAM_CODEC, Display::base, (StreamCodec)SlotDisplay.STREAM_CODEC, Display::addition, (StreamCodec)SlotDisplay.STREAM_CODEC, Display::result, (StreamCodec)SlotDisplay.STREAM_CODEC, Display::craftingStation, Display::new);
        public static final RecipeDisplay.Type<Display> TYPE = new RecipeDisplay.Type(MAP_CODEC, STREAM_CODEC);

        @NotNull
        public RecipeDisplay.Type<? extends RecipeDisplay> type() {
            return TYPE;
        }
    }

    public record DemoSlotDisplay(SlotDisplay base, SlotDisplay material) implements SlotDisplay
    {
        public static final MapCodec<DemoSlotDisplay> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SlotDisplay.CODEC.fieldOf("base").forGetter(DemoSlotDisplay::base), (App)SlotDisplay.CODEC.fieldOf("material").forGetter(DemoSlotDisplay::material)).apply((Applicative)instance, DemoSlotDisplay::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DemoSlotDisplay> STREAM_CODEC = StreamCodec.composite((StreamCodec)SlotDisplay.STREAM_CODEC, DemoSlotDisplay::base, (StreamCodec)SlotDisplay.STREAM_CODEC, DemoSlotDisplay::material, DemoSlotDisplay::new);
        public static final SlotDisplay.Type<DemoSlotDisplay> TYPE = new SlotDisplay.Type(MAP_CODEC, STREAM_CODEC);

        @NotNull
        public <T> Stream<T> resolve(@NotNull ContextMap contextMap, @NotNull DisplayContentsFactory<T> displayContentsFactory) {
            if (!(displayContentsFactory instanceof DisplayContentsFactory.ForStacks)) {
                return Stream.empty();
            }
            DisplayContentsFactory.ForStacks forStacks = (DisplayContentsFactory.ForStacks)displayContentsFactory;
            HolderLookup.Provider provider = (HolderLookup.Provider)contextMap.getOptional(SlotDisplayContext.REGISTRIES);
            if (provider == null) {
                return Stream.empty();
            }
            RandomSource randomSource = RandomSource.create((long)System.identityHashCode(this));
            List list = this.base.resolveForStacks(contextMap);
            if (list.isEmpty()) {
                return Stream.empty();
            }
            List list2 = this.material.resolveForStacks(contextMap);
            if (list2.isEmpty()) {
                return Stream.empty();
            }
            return Stream.generate(() -> {
                ItemStack itemStack = (ItemStack)Util.getRandom((List)list, (RandomSource)randomSource);
                ItemStack itemStack2 = (ItemStack)Util.getRandom((List)list2, (RandomSource)randomSource);
                return MaterialAdditionRecipe.applyMaterialAddition(itemStack, itemStack2);
            }).limit(256L).filter(itemStack -> !itemStack.isEmpty()).limit(16L).map(arg_0 -> ((DisplayContentsFactory.ForStacks)forStacks).forStack(arg_0));
        }

        @NotNull
        public SlotDisplay.Type<? extends SlotDisplay> type() {
            return TYPE;
        }
    }
}

