/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.api.client.impl;

import com.bawnorton.trimica.api.client.TrimicaRenderer;
import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.compat.Compat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemDisplayContext;

public final class TrimicaRendererImpl
implements TrimicaRenderer {
    @Override
    public void renderShieldTrim(ModelPart plate, DataComponentMap dataComponentMap, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, boolean hasFoil) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("trimica:shield");
        List<DynamicTrimTextureAtlasSprite> dynamicSprites = TrimicaClient.getRuntimeAtlases().getShieldSprites(Minecraft.getInstance().level, (DataComponentGetter)dataComponentMap);
        for (DynamicTrimTextureAtlasSprite dynamicSprite : dynamicSprites) {
            int light;
            TrimPalette palette = dynamicSprite.getPalette();
            int n = palette == null ? packedLight : (light = palette.isEmissive() ? 0xF000F0 : packedLight);
            if (palette != null && palette.isAnimated()) {
                Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(dynamicSprite));
            }
            VertexConsumer vertexConsumer = dynamicSprite.wrap(ItemRenderer.getFoilBuffer((MultiBufferSource)multiBufferSource, (RenderType)dynamicSprite.getRenderType(), (itemDisplayContext == ItemDisplayContext.GUI ? 1 : 0) != 0, (boolean)hasFoil));
            plate.render(poseStack, vertexConsumer, light, packedOverlay);
        }
        profiler.pop();
    }
}

