/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.mixin.model;

import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.extend.ItemStackRenderState$LayerRenderStateExtender;
import com.bawnorton.trimica.client.mixin.accessor.BlockModelWrapperAccessor;
import com.bawnorton.trimica.client.model.TrimItemModelFactory;
import com.bawnorton.trimica.client.model.TrimmedItemModelWrapper;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BlockModelWrapper.class})
abstract class BlockModelWrapperMixin {
    @Shadow
    @Final
    @Mutable
    private List<ItemTintSource> tints;
    @Shadow
    @Final
    @Mutable
    private List<BakedQuad> quads;
    @Shadow
    @Final
    @Mutable
    private Supplier<Vector3f[]> extents;
    @Shadow
    @Final
    @Mutable
    private ModelRenderProperties properties;

    BlockModelWrapperMixin() {
    }

    @WrapMethod(method={"update"})
    private void createNewLayerRenderStateForTrimOverlay(ItemStackRenderState renderState, ItemStack stack, ItemModelResolver itemModelResolver, ItemDisplayContext displayContext, ClientLevel level, LivingEntity livingEntity, int i, Operation<Void> original) {
        Runnable callOriginal = () -> original.call(new Object[]{renderState, stack, itemModelResolver, displayContext, level, livingEntity, i});
        List<ArmorTrim> trims = AdditionalTrims.getAllTrims((DataComponentGetter)stack);
        if (trims.isEmpty()) {
            callOriginal.run();
            return;
        }
        ProfilerFiller profiler = Profiler.get();
        boolean isEmissive = false;
        boolean isAnimated = false;
        ArrayList<TrimmedItemModelWrapper> trimModelWrappers = new ArrayList<TrimmedItemModelWrapper>();
        for (ArmorTrim trim : trims) {
            profiler.push("trimica:item_runtime_atlas");
            TrimItemModelFactory itemModelFactory = TrimicaClient.getItemModelFactory();
            TrimmedItemModelWrapper newModel = itemModelFactory.getOrCreateModel((ItemModel)this, level, stack, trim);
            trimModelWrappers.add(newModel);
            profiler.pop();
            TrimPalette palette = newModel.palette();
            if (palette == null) continue;
            if (palette.isEmissive()) {
                isEmissive = true;
            }
            if (!palette.isAnimated()) continue;
            isAnimated = true;
        }
        if (isAnimated) {
            renderState.setAnimated();
        }
        ItemStackRenderState.FoilType foilType = ItemStackRenderState.FoilType.SPECIAL;
        if (stack.hasFoil()) {
            renderState.appendModelIdentityElement((Object)foilType);
        }
        for (TrimmedItemModelWrapper newModel : trimModelWrappers) {
            ArrayList<ItemTintSource> originalTints = new ArrayList<ItemTintSource>(this.tints);
            ArrayList<BakedQuad> originalQuads = new ArrayList<BakedQuad>(this.quads);
            Vector3f[] originalExtents = this.extents.get();
            Supplier<Vector3f[]> originalExtentsSupplier = () -> originalExtents;
            ModelRenderProperties originalProperties = new ModelRenderProperties(this.properties.usesBlockLight(), this.properties.particleIcon(), this.properties.transforms());
            ItemModel itemModel = newModel.model();
            if (itemModel instanceof BlockModelWrapperAccessor) {
                BlockModelWrapperAccessor blockModelWrapper = (BlockModelWrapperAccessor)itemModel;
                this.tints = blockModelWrapper.trimica$tints();
                this.quads = blockModelWrapper.trimica$quads();
                this.extents = blockModelWrapper.trimica$extents();
                this.properties = blockModelWrapper.trimica$properties();
            }
            int lastBaseTextureIndex = -1;
            ResourceLocation overlayAtlas = null;
            for (int j = 0; j < this.quads.size(); ++j) {
                BakedQuad quad = this.quads.get(j);
                if (!quad.sprite().atlasLocation().getNamespace().equals("trimica")) continue;
                lastBaseTextureIndex = j;
                overlayAtlas = quad.sprite().atlasLocation();
                break;
            }
            if (overlayAtlas == null) {
                this.tints = originalTints;
                this.quads = originalQuads;
                this.extents = originalExtentsSupplier;
                this.properties = originalProperties;
                callOriginal.run();
                return;
            }
            ArrayList<BakedQuad> overlayQuads = new ArrayList<BakedQuad>(this.quads.subList(lastBaseTextureIndex, this.quads.size()));
            this.quads = new ArrayList<BakedQuad>(this.quads.subList(0, lastBaseTextureIndex));
            callOriginal.run();
            ItemStackRenderState.LayerRenderState overlayRenderState = renderState.newLayer();
            ItemStackRenderState$LayerRenderStateExtender extender = (ItemStackRenderState$LayerRenderStateExtender)overlayRenderState;
            extender.trimica$markAsTrimOverlay();
            ResourceLocation modelLocation = newModel.location();
            renderState.appendModelIdentityElement((Object)modelLocation);
            extender.trimica$setEmissive(isEmissive);
            if (stack.hasFoil()) {
                overlayRenderState.setFoilType(foilType);
            }
            overlayRenderState.setRenderType(RenderType.itemEntityTranslucentCull((ResourceLocation)overlayAtlas));
            this.properties.applyToLayer(overlayRenderState, displayContext);
            overlayRenderState.prepareQuadList().addAll(overlayQuads);
            this.quads = originalQuads;
            profiler.pop();
        }
    }
}

