/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.model;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.trim.TrimmedType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.jetbrains.annotations.Nullable;

public record TrimModelId(TrimmedType type, ResourceLocation patternId, ResourceLocation materialId, @Nullable ResourceLocation assetId) {
    public ResourceLocation asSingle() {
        Object assetPrefix = this.assetId == null ? "" : "%s/".formatted(this.assetId.toString().replace(":", "/"));
        assetPrefix = (String)assetPrefix + this.type.getName();
        return Trimica.rl("%s/%s/%s/%s".formatted(assetPrefix, this.patternId.getNamespace(), this.patternId.getPath(), this.materialId.getPath()));
    }

    public static TrimModelId fromTrim(TrimmedType trimmedType, ArmorTrim trim, @Nullable ResourceKey<EquipmentAsset> assetKey) {
        ResourceLocation materialId = Trimica.rl(Trimica.getMaterialRegistry().getSuffix((TrimMaterial)trim.material().value(), assetKey));
        ResourceLocation patternId = ((TrimPattern)trim.pattern().value()).assetId();
        return new TrimModelId(trimmedType, patternId, materialId, assetKey == null ? null : assetKey.location());
    }
}

