/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.palette;

import com.bawnorton.trimica.client.colour.OkLabHelper;
import com.bawnorton.trimica.client.palette.TrimPalette;
import java.util.ArrayList;
import java.util.List;

public final class AnimatedTrimPalette
extends TrimPalette {
    public static final int ANIMATED_PALETTE_SIZE = 72;
    private static int offset = 0;
    private final List<Integer> interpolatedColours;

    AnimatedTrimPalette(List<Integer> colours) {
        super(colours);
        int first = colours.getFirst();
        ArrayList<Integer> base = new ArrayList<Integer>(9);
        base.addAll(colours);
        base.add(first);
        List<double[]> okLab = OkLabHelper.rgbToOklab(base);
        List<double[]> stretched = OkLabHelper.strechOkLab(72, 9, okLab);
        this.interpolatedColours = OkLabHelper.okLabToRgb(stretched);
    }

    @Override
    public TrimPalette asAnimated() {
        return this;
    }

    @Override
    public boolean isAnimated() {
        return true;
    }

    public static void updateOffset() {
        offset = (offset + 1) % 72;
    }

    @Override
    public int getTooltipColour() {
        return this.interpolatedColours.get(offset);
    }

    public List<Integer> getAnimationColours() {
        ArrayList<Integer> colours = new ArrayList<Integer>(24);
        for (int i = 0; i < 72; i += 3) {
            colours.add(this.interpolatedColours.get(i % 72));
        }
        return colours;
    }
}

