/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.command;

import com.bawnorton.configurable.api.ConfigurableApi;
import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.ComponentUtil;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Rotations;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;

public class TrimicaCommandManager {
    public static void init(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"trimica").then(((LiteralArgumentBuilder)Commands.literal((String)"debug").requires(source -> source.hasPermission(4))).then(((LiteralArgumentBuilder)Commands.literal((String)"summon").then(Commands.literal((String)"all").executes(context -> {
            TrimicaCommandManager.summonArmourStands((CommandContext<CommandSourceStack>)context, true);
            return 1;
        }))).executes(context -> TrimicaCommandManager.summonArmourStands((CommandContext<CommandSourceStack>)context, false))))).then(((LiteralArgumentBuilder)Commands.literal((String)"toggle").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"configEntry", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest(List.of("trimEverything", "materialAdditions", "perPatternItemTextures", "additionalTrims"), (SuggestionsBuilder)builder)).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest(List.of("true", "false"), (SuggestionsBuilder)builder)).executes(TrimicaCommandManager::setConfigValue)))));
    }

    private static int summonArmourStands(CommandContext<CommandSourceStack> context, boolean allMaterials) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        RegistryAccess registryAccess = source.registryAccess();
        Registry patternLookup = registryAccess.lookupOrThrow(Registries.TRIM_PATTERN);
        ServerLevel level = source.getLevel();
        BlockPos.MutableBlockPos pos = BlockPos.containing((Position)source.getPosition()).mutable();
        List<Object> materials = allMaterials ? registryAccess.lookupOrThrow(Registries.ITEM).listElements().map(itemRef -> {
            Item item = (Item)itemRef.value();
            ProvidesTrimMaterial trimMaterialProvider = (ProvidesTrimMaterial)item.getDefaultInstance().get(DataComponents.PROVIDES_TRIM_MATERIAL);
            if (trimMaterialProvider == null) {
                return null;
            }
            return trimMaterialProvider.material().unwrap((HolderLookup.Provider)registryAccess).orElse(null);
        }).filter(Objects::nonNull).toList() : registryAccess.lookupOrThrow(Registries.TRIM_MATERIAL).listElements().toList();
        source.sendSystemMessage((Component)Component.literal((String)"Summoning %s armour stands at %s".formatted(patternLookup.listElementIds().count() * (long)materials.size(), pos.toShortString())));
        Object ref = new Object(){
            boolean flag = false;
        };
        patternLookup.listElements().forEach(arg_0 -> TrimicaCommandManager.lambda$summonArmourStands$10(materials, level, pos, ref, arg_0));
        return 1;
    }

    private static int setConfigValue(CommandContext<CommandSourceStack> context) {
        boolean newValue;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String configEntry = StringArgumentType.getString(context, (String)"configEntry");
        String value = StringArgumentType.getString(context, (String)"value");
        try {
            newValue = Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)"Invalid value: %s. Must be 'true' or 'false'.".formatted(value)));
            return 0;
        }
        switch (configEntry) {
            case "trimEverything": {
                TrimMaterialRuntimeRegistry.enableTrimEverything = newValue;
                ConfigurableApi.saveChanges((ServerLevel)source.getLevel(), (boolean)true);
                break;
            }
            case "materialAdditions": {
                MaterialAdditions.enableMaterialAdditions = newValue;
                ConfigurableApi.saveChanges((ServerLevel)source.getLevel(), (boolean)true);
                break;
            }
            case "perPatternItemTextures": {
                Trimica.enablePerPatternItemTextures = newValue;
                ConfigurableApi.saveChanges((ServerLevel)source.getLevel(), (boolean)true);
                break;
            }
            case "additionalTrims": {
                AdditionalTrims.enableAdditionalTrims = newValue;
                ConfigurableApi.saveChanges((ServerLevel)source.getLevel(), (boolean)true);
                break;
            }
            default: {
                source.sendFailure((Component)Component.literal((String)"Unknown config entry: %s".formatted(configEntry)));
                return 0;
            }
        }
        source.sendSuccess(() -> Component.literal((String)"Set %s to %s".formatted(configEntry, value)), true);
        return 1;
    }

    private static /* synthetic */ void lambda$summonArmourStands$10(List materials, ServerLevel level, BlockPos.MutableBlockPos pos, 1 ref, Holder.Reference patternRef) {
        materials.forEach(materialRef -> {
            List<ItemStack> toEquip = ComponentUtil.getTrimmedEquipment(new ArmorTrim(materialRef, (Holder)patternRef));
            ArmorStand stand = (ArmorStand)EntityType.ARMOR_STAND.create(level, armourStand -> {
                armourStand.setNoGravity(true);
                armourStand.setNoBasePlate(true);
                armourStand.setShowArms(true);
                armourStand.absSnapRotationTo(0.0f, 0.0f);
                armourStand.setLeftArmPose(new Rotations(-70.0f, 80.0f, -20.0f));
                toEquip.forEach(stack -> {
                    Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
                    assert (equippable != null);
                    armourStand.setItemSlot(equippable.slot(), stack);
                });
            }, (BlockPos)pos, EntitySpawnReason.MOB_SUMMONED, false, false);
            if (stand != null) {
                level.addFreshEntity((Entity)stand);
            }
            pos.move(Direction.EAST, 2);
        });
        pos.move(Direction.WEST, 2 * materials.size());
        pos.move(Direction.UP);
        ref.flag = !ref.flag;
        if (ref.flag) {
            pos.move(Direction.WEST);
        } else {
            pos.move(Direction.EAST);
        }
        pos.move(Direction.NORTH);
    }
}

