/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.item.component;

import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.trim.ArmorTrim;

public record AdditionalTrims(List<ArmorTrim> trims) {
    public static DataComponentType<AdditionalTrims> TYPE;
    public static final Codec<AdditionalTrims> CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, AdditionalTrims> STREAM_CODEC;
    public static boolean enableAdditionalTrims;

    public AdditionalTrims(ArmorTrim ... trims) {
        this(List.of(trims));
    }

    public static AdditionalTrims empty() {
        return new AdditionalTrims(new ArmorTrim[0]);
    }

    public boolean isEmpty() {
        return this.trims.isEmpty();
    }

    public List<ArmorTrim> mutableTrims() {
        return new ArrayList<ArmorTrim>(this.trims);
    }

    public static List<ArmorTrim> getAllTrims(DataComponentGetter getter) {
        if (getter == null) {
            return List.of();
        }
        if (!enableAdditionalTrims) {
            ArmorTrim normalTrim = (ArmorTrim)getter.get(DataComponents.TRIM);
            if (normalTrim != null) {
                return List.of(normalTrim);
            }
            return List.of();
        }
        AdditionalTrims additionalTrims = (AdditionalTrims)getter.getOrDefault(TYPE, (Object)AdditionalTrims.empty());
        List<ArmorTrim> allTrims = additionalTrims.mutableTrims();
        ArmorTrim normalTrim = (ArmorTrim)getter.get(DataComponents.TRIM);
        if (normalTrim != null) {
            allTrims.addFirst(normalTrim);
        }
        return allTrims;
    }

    public static boolean tryAddTrim(ItemStack stack, ArmorTrim trim) {
        if (!stack.has(DataComponents.TRIM)) {
            stack.set(DataComponents.TRIM, (Object)trim);
            return true;
        }
        if (!enableAdditionalTrims) {
            return false;
        }
        AdditionalTrims additionalTrims = (AdditionalTrims)stack.getOrDefault(TYPE, (Object)AdditionalTrims.empty());
        if (additionalTrims.trims().contains(trim)) {
            return false;
        }
        List<ArmorTrim> newTrims = additionalTrims.mutableTrims();
        newTrims.add(trim);
        stack.set(TYPE, (Object)new AdditionalTrims(newTrims));
        return true;
    }

    public static int removeTrims(ItemStack stack, int count) {
        if (!enableAdditionalTrims) {
            if (count <= 0 || !stack.has(DataComponents.TRIM)) {
                return count;
            }
            stack.remove(DataComponents.TRIM);
            if (MaterialAdditions.enableMaterialAdditions) {
                stack.remove(MaterialAdditions.TYPE);
            }
            return count - 1;
        }
        AdditionalTrims additionalTrims = (AdditionalTrims)stack.getOrDefault(TYPE, (Object)AdditionalTrims.empty());
        if (count <= 0 || additionalTrims.isEmpty() && !stack.has(DataComponents.TRIM)) {
            return 0;
        }
        List<ArmorTrim> newTrims = additionalTrims.mutableTrims();
        while (count > 0 && !newTrims.isEmpty()) {
            newTrims.removeLast();
            --count;
        }
        if (count > 0 && stack.has(DataComponents.TRIM)) {
            stack.remove(DataComponents.TRIM);
            --count;
        }
        if (newTrims.isEmpty()) {
            stack.remove(TYPE);
            if (!stack.has(DataComponents.TRIM) && MaterialAdditions.enableMaterialAdditions) {
                stack.remove(MaterialAdditions.TYPE);
            }
        } else {
            stack.set(TYPE, (Object)new AdditionalTrims(newTrims));
        }
        return count;
    }

    public static void correctTrimComponents(ItemStack stack) {
        if (!enableAdditionalTrims) {
            return;
        }
        if (!stack.has(TYPE) || stack.has(DataComponents.TRIM)) {
            return;
        }
        AdditionalTrims additionalTrims = (AdditionalTrims)stack.getOrDefault(TYPE, (Object)AdditionalTrims.empty());
        if (additionalTrims.isEmpty()) {
            return;
        }
        List<ArmorTrim> trims = additionalTrims.mutableTrims();
        ArmorTrim firstTrim = trims.removeFirst();
        stack.set(DataComponents.TRIM, (Object)firstTrim);
        if (trims.isEmpty()) {
            stack.remove(TYPE);
        } else {
            stack.set(TYPE, (Object)new AdditionalTrims(trims));
        }
    }

    public static boolean hasTrim(ItemStack stack, ArmorTrim trim) {
        List<ArmorTrim> allTrims = AdditionalTrims.getAllTrims((DataComponentGetter)stack);
        for (ArmorTrim armorTrim : allTrims) {
            if (!armorTrim.equals((Object)trim)) continue;
            return true;
        }
        return false;
    }

    static {
        CODEC = ArmorTrim.CODEC.listOf().xmap(list -> new AdditionalTrims(List.copyOf(list)), additionalTrims -> additionalTrims == null ? List.of() : List.copyOf(additionalTrims.trims));
        STREAM_CODEC = ByteBufCodecs.list().apply(ArmorTrim.STREAM_CODEC).map(list -> new AdditionalTrims(List.copyOf(list)), additionalTrims -> additionalTrims == null ? List.of() : List.copyOf(additionalTrims.trims));
        enableAdditionalTrims = false;
    }
}

