/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.item.component;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.DataComponentSetter;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentUtil {
    @Nullable
    public static ArmorType getArmourType(DataComponentGetter componentGetter) {
        Equippable equippable = (Equippable)componentGetter.get(DataComponents.EQUIPPABLE);
        if (equippable == null) {
            return null;
        }
        EquipmentSlot slot = equippable.slot();
        return switch (slot) {
            case EquipmentSlot.FEET -> ArmorType.BOOTS;
            case EquipmentSlot.LEGS -> ArmorType.LEGGINGS;
            case EquipmentSlot.CHEST -> ArmorType.CHESTPLATE;
            case EquipmentSlot.HEAD -> ArmorType.HELMET;
            default -> null;
        };
    }

    @NotNull
    public static List<ItemStack> getTrimmedEquipment(ArmorTrim trim) {
        return Stream.of(Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS, Items.SHIELD).map(item -> {
            ItemStack stack = item.getDefaultInstance();
            stack.set(DataComponents.TRIM, (Object)trim);
            return stack;
        }).toList();
    }

    @Nullable
    public static <T> T getFakeComponents(DataComponentGetter instance, T original, DataComponentType<? extends T> type) {
        if (original != null) {
            return original;
        }
        if (type == DataComponents.PROVIDES_TRIM_MATERIAL && instance instanceof ItemStack) {
            ItemStack stack = (ItemStack)instance;
            if (TrimMaterialRuntimeRegistry.enableTrimEverything) {
                return (T)new ProvidesTrimMaterial(Trimica.getMaterialRegistry().getOrCreate((DataComponentGetter)stack));
            }
        }
        return null;
    }

    public static <T> void setFakeComponents(DataComponentSetter setter, DataComponentGetter getter, DataComponentType<T> type, @Nullable T object) {
        if (!MaterialAdditions.enableMaterialAdditions) {
            return;
        }
        if (object == null) {
            return;
        }
        if (type == DataComponents.TRIM) {
            ArmorTrim trim = (ArmorTrim)object;
            MaterialAdditions additions = (MaterialAdditions)getter.getOrDefault(MaterialAdditions.TYPE, (Object)MaterialAdditions.NONE);
            TrimMaterial trimMaterial = (TrimMaterial)trim.material().value();
            if ((additions = additions.and(Trimica.getMaterialRegistry().getIntrinsicAdditions(trimMaterial))).isEmpty()) {
                return;
            }
            setter.set(MaterialAdditions.TYPE, additions);
        } else if (AdditionalTrims.enableAdditionalTrims && type == AdditionalTrims.TYPE) {
            AdditionalTrims additionalTrims = (AdditionalTrims)object;
            MaterialAdditions additions = (MaterialAdditions)getter.getOrDefault(MaterialAdditions.TYPE, (Object)MaterialAdditions.NONE);
            for (ArmorTrim trim : additionalTrims.trims()) {
                TrimMaterial trimMaterial = (TrimMaterial)trim.material().value();
                additions = additions.and(Trimica.getMaterialRegistry().getIntrinsicAdditions(trimMaterial));
            }
            if (additions.isEmpty()) {
                return;
            }
            setter.set(MaterialAdditions.TYPE, additions);
        }
    }
}

