/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.mixin.crafting;

import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin
extends ItemCombinerMenu {
    @Shadow
    private int repairItemCountCost;
    @Shadow
    @Nullable
    private String itemName;
    @Shadow
    @Final
    private DataSlot cost;

    public AnvilMenuMixin(@Nullable MenuType<?> menuType, int containerId, Inventory inventory, ContainerLevelAccess access, ItemCombinerMenuSlotDefinition slotDefinition) {
        super(menuType, containerId, inventory, access, slotDefinition);
    }

    @Inject(method={"createResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void addTrimRemovalResult(CallbackInfo ci) {
        ItemStack armour = this.inputSlots.getItem(0);
        ItemStack tool = this.inputSlots.getItem(1);
        ItemStack mutableArmour = armour.copy();
        if (tool.is(Items.FLINT)) {
            AdditionalTrims.correctTrimComponents(mutableArmour);
            int remainder = AdditionalTrims.removeTrims(mutableArmour, tool.getCount());
            this.trimica$applyTool(ci, armour, tool, mutableArmour, remainder);
        } else if (tool.is(Items.FEATHER) && MaterialAdditions.enableMaterialAdditions) {
            int remainder = MaterialAdditions.removeMaterials(mutableArmour, tool.getCount());
            this.trimica$applyTool(ci, armour, tool, mutableArmour, remainder);
        }
    }

    @Unique
    private void trimica$applyTool(CallbackInfo ci, ItemStack armour, ItemStack tool, ItemStack mutableArmour, int remainder) {
        if (!ItemStack.matches((ItemStack)mutableArmour, (ItemStack)armour)) {
            this.resultSlots.setItem(0, mutableArmour);
            int cost = this.repairItemCountCost = tool.getCount() - remainder;
            if (this.itemName != null && !StringUtil.isBlank((String)this.itemName)) {
                if (!this.itemName.equals(armour.getHoverName().getString())) {
                    ++cost;
                    mutableArmour.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.itemName));
                }
            } else if (armour.has(DataComponents.CUSTOM_NAME)) {
                ++cost;
                mutableArmour.remove(DataComponents.CUSTOM_NAME);
            }
            this.cost.set(cost);
            this.broadcastChanges();
            ci.cancel();
        }
    }
}

