/*
 * Decompiled with CFR 0.152.
 */
package com.combatsync;

import com.combatsync.CombatSync;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final CombatSync plugin;
    private boolean enabled;
    private boolean knockbackEnabled;
    private boolean normalizeKnockback;
    private double baseMultiplier;
    private int maxPingThreshold;
    private int minPingThreshold;
    private boolean compensationEnabled;
    private double lowPingReduction;
    private double highPingBoost;
    private boolean smoothTransitions;
    private boolean syncPackets;
    private boolean delayCompensation;
    private int bufferTime;
    private boolean debugMode;
    private boolean exemptCreative;

    public ConfigManager(CombatSync plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        FileConfiguration config = this.plugin.getConfig();
        this.enabled = config.getBoolean("enabled", true);
        this.knockbackEnabled = config.getBoolean("knockback.enabled", true);
        this.normalizeKnockback = config.getBoolean("knockback.normalize", true);
        this.baseMultiplier = config.getDouble("knockback.base-multiplier", 1.0);
        this.maxPingThreshold = config.getInt("knockback.max-ping-threshold", 300);
        this.minPingThreshold = config.getInt("knockback.min-ping-threshold", 20);
        this.compensationEnabled = config.getBoolean("compensation.enabled", true);
        this.lowPingReduction = config.getDouble("compensation.low-ping-reduction", 0.85);
        this.highPingBoost = config.getDouble("compensation.high-ping-boost", 1.15);
        this.smoothTransitions = config.getBoolean("compensation.smooth-transitions", true);
        this.syncPackets = config.getBoolean("velocity.sync-packets", true);
        this.delayCompensation = config.getBoolean("velocity.delay-compensation", true);
        this.bufferTime = config.getInt("velocity.buffer-time", 50);
        this.debugMode = config.getBoolean("settings.debug-mode", false);
        this.exemptCreative = config.getBoolean("settings.exempt-creative", true);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isKnockbackEnabled() {
        return this.knockbackEnabled;
    }

    public boolean isNormalizeKnockback() {
        return this.normalizeKnockback;
    }

    public double getBaseMultiplier() {
        return this.baseMultiplier;
    }

    public int getMaxPingThreshold() {
        return this.maxPingThreshold;
    }

    public int getMinPingThreshold() {
        return this.minPingThreshold;
    }

    public boolean isCompensationEnabled() {
        return this.compensationEnabled;
    }

    public double getLowPingReduction() {
        return this.lowPingReduction;
    }

    public double getHighPingBoost() {
        return this.highPingBoost;
    }

    public boolean isSmoothTransitions() {
        return this.smoothTransitions;
    }

    public boolean isSyncPackets() {
        return this.syncPackets;
    }

    public boolean isDelayCompensation() {
        return this.delayCompensation;
    }

    public int getBufferTime() {
        return this.bufferTime;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isExemptCreative() {
        return this.exemptCreative;
    }
}

