/*
 * Decompiled with CFR 0.152.
 */
package com.combatsync;

import com.combatsync.CombatSync;
import com.combatsync.ConfigManager;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class KnockbackManager {
    private final CombatSync plugin;

    public KnockbackManager(CombatSync plugin) {
        this.plugin = plugin;
    }

    public Vector calculateAdjustedKnockback(Player victim, Vector originalVelocity) {
        ConfigManager config = this.plugin.getConfigManager();
        if (!config.isKnockbackEnabled() || !config.isNormalizeKnockback()) {
            return originalVelocity;
        }
        int ping = this.getPing(victim);
        double multiplier = this.calculateMultiplier(ping);
        Vector adjusted = originalVelocity.clone().multiply(multiplier);
        if (config.isDebugMode()) {
            this.plugin.getLogger().info(String.format("Player: %s, Ping: %d, Multiplier: %.2f", victim.getName(), ping, multiplier));
        }
        return adjusted;
    }

    private double calculateMultiplier(int ping) {
        ConfigManager config = this.plugin.getConfigManager();
        if (!config.isCompensationEnabled()) {
            return config.getBaseMultiplier();
        }
        int minPing = config.getMinPingThreshold();
        int maxPing = config.getMaxPingThreshold();
        if (ping <= minPing) {
            return config.getBaseMultiplier() * config.getLowPingReduction();
        }
        if (ping >= maxPing) {
            return config.getBaseMultiplier() * config.getHighPingBoost();
        }
        if (config.isSmoothTransitions()) {
            double range = maxPing - minPing;
            double position = (double)(ping - minPing) / range;
            double minMultiplier = config.getLowPingReduction();
            double maxMultiplier = config.getHighPingBoost();
            double interpolated = minMultiplier + (maxMultiplier - minMultiplier) * position;
            return config.getBaseMultiplier() * interpolated;
        }
        return config.getBaseMultiplier();
    }

    private int getPing(Player player) {
        try {
            return player.getPing();
        }
        catch (Exception e) {
            return 100;
        }
    }
}

