/*
 * Decompiled with CFR 0.152.
 */
package com.combatsync;

import com.combatsync.CombatSync;
import com.combatsync.ConfigManager;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class CombatListener
implements Listener {
    private final CombatSync plugin;

    public CombatListener(CombatSync plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        ConfigManager config = this.plugin.getConfigManager();
        if (!config.isEnabled() || !config.isKnockbackEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player victim = (Player)event.getEntity();
        if (config.isExemptCreative() && victim.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Player attacker = event.getDamager() instanceof Player ? (Player)event.getDamager() : null;
        Vector currentVelocity = victim.getVelocity().clone();
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            if (!victim.isOnline() || victim.isDead()) {
                return;
            }
            Vector newVelocity = victim.getVelocity();
            Vector knockbackDelta = newVelocity.clone().subtract(currentVelocity);
            if (knockbackDelta.lengthSquared() < 1.0E-5) {
                return;
            }
            Vector adjustedKnockback = this.plugin.getKnockbackManager().calculateAdjustedKnockback(victim, attacker, knockbackDelta);
            Vector finalVelocity = currentVelocity.clone().add(adjustedKnockback);
            finalVelocity.setY(Math.max(-3.0, Math.min(3.0, finalVelocity.getY())));
            finalVelocity.setX(Math.max(-4.0, Math.min(4.0, finalVelocity.getX())));
            finalVelocity.setZ(Math.max(-4.0, Math.min(4.0, finalVelocity.getZ())));
            victim.setVelocity(finalVelocity);
        });
    }
}

