/*
 * Decompiled with CFR 0.152.
 */
package com.combatsync;

import com.combatsync.CombatSync;
import com.combatsync.ConfigManager;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class KnockbackManager {
    private final CombatSync plugin;

    public KnockbackManager(CombatSync plugin) {
        this.plugin = plugin;
    }

    public Vector calculateAdjustedKnockback(Player victim, Player attacker, Vector originalVelocity) {
        ConfigManager config = this.plugin.getConfigManager();
        if (!config.isKnockbackEnabled() || !config.isNormalizeKnockback()) {
            return originalVelocity;
        }
        int victimPing = this.getPing(victim);
        int attackerPing = attacker != null ? this.getPing(attacker) : 0;
        double multiplier = this.calculateMultiplier(victimPing, attackerPing);
        Vector adjusted = originalVelocity.clone();
        adjusted.setX(adjusted.getX() * multiplier);
        adjusted.setZ(adjusted.getZ() * multiplier);
        adjusted.setY(adjusted.getY() * (multiplier * 0.95));
        if (config.isDebugMode()) {
            this.plugin.getLogger().info(String.format("Victim: %s (Ping: %d) | Attacker: %s (Ping: %d) | Multiplier: %.3f", victim.getName(), victimPing, attacker != null ? attacker.getName() : "N/A", attackerPing, multiplier));
        }
        return adjusted;
    }

    private double calculateMultiplier(int victimPing, int attackerPing) {
        ConfigManager config = this.plugin.getConfigManager();
        if (!config.isCompensationEnabled()) {
            return config.getBaseMultiplier();
        }
        int avgPing = (victimPing + attackerPing) / 2;
        int pingDiff = Math.abs(victimPing - attackerPing);
        int minPing = config.getMinPingThreshold();
        int maxPing = config.getMaxPingThreshold();
        double baseMultiplier = config.getBaseMultiplier();
        if (avgPing <= minPing && pingDiff < 30) {
            return baseMultiplier * config.getLowPingReduction();
        }
        if (avgPing >= maxPing) {
            return baseMultiplier * config.getHighPingBoost();
        }
        if (config.isSmoothTransitions()) {
            double normalizedPing = (double)(avgPing - minPing) / (double)(maxPing - minPing);
            normalizedPing = Math.max(0.0, Math.min(1.0, normalizedPing));
            double minMultiplier = config.getLowPingReduction();
            double maxMultiplier = config.getHighPingBoost();
            double curve = normalizedPing * normalizedPing;
            double interpolated = minMultiplier + (maxMultiplier - minMultiplier) * curve;
            if (pingDiff > 50) {
                double diffFactor = Math.min((double)pingDiff / 200.0, 0.3);
                interpolated += diffFactor;
            }
            return baseMultiplier * interpolated;
        }
        return baseMultiplier;
    }

    private int getPing(Player player) {
        try {
            int ping = player.getPing();
            return Math.max(0, Math.min(500, ping));
        }
        catch (Exception e) {
            return 50;
        }
    }
}

